
<?php $__env->startSection('content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Kategori</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class=" breadcrumb-item"><a href="#">Home</a></li>
                    <li class=" breadcrumb-item active">Kategori</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h2 class="card-title h2">Data User</h2>
                        <div class=" card-tools">
                          <button class="btn btn-tool" onclick="table.ajax.reload()"><i class="fas fa-sync-alt"></i></button>
                          <button class="btn btn-tool mr-2" data-card-widget="maximize">
                            <i class="fas fa-expand"></i>
                          </button>
                          <button class="btn btn-sm btn-primary" onclick="addCategory()"><i class="fas fa-plus-square mr-2"></i>Tambah</button>
                        </div>
                    </div>
                    <div class="card-body">
                        <table class="table table-hover" style="width: 100%;">
                            <thead>
                                <th>#</th>
                                <th>Nama</th>
                                <th>Deskripsi</th>
                                <th></th>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="modal">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Tambah Kategori</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="">
                        <div class="modal-body">
                            <div class="form-group mb-3">
                                <label for="" class="">Nama</label>
                                <input type="text" class="form-control" id="name" name="name" required placeholder="Nama Kategori">
                            </div>
                            <div class="form-group">
                                <label for="" class="">Deskripsi</label>
                                <textarea class="form-control" name="description"></textarea>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary"><span>Simpan</span></button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    var table = $('.table').DataTable({
        processing: true,
        serverSide: true,
        order: [1, 'asc'],
        ajax: {
            url: "<?php echo e(url('admin/kategori/list-data')); ?>",
            type: "get",
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')}
        },
        columns: [
            {data: null, width: '30px', class: '', orderable: false, render: function(data, type, row, meta){
                return meta.row + meta.settings._iDisplayStart + 1;
            }},
            {data: 'name'},
            {data: 'description'},
            {data: null, width: '30px', orderable: false, render: function(data, type, row){
                return `<div class='dropdown'>
                    <a href='#' data-toggle='dropdown' class='text-sm text-muted'>
                        <i class='fas fa-cog'></i>
                    </a>
                    <div class='dropdown-menu dropdown-menu-right text-sm'> 
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update opd')): ?>
                        <a href='#' class='dropdown-item' onclick='event.preventDefault(); editCategory(${data.id})'><i class='fas fa-edit mr-2'></i> Edit</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete opd')): ?>
                        <a href='#' class='dropdown-item' onclick='event.preventDefault(); deleteCategory(${data.id})'><i class=' fas fa-trash-alt mr-2'></i> Hapus</a>
                        <?php endif; ?>
                    </div> 
                </div>`;
            }}
        ]
    });

    var submitUrl = '';
    var modal = $('#modal');
    var form = modal.find('form');
    var btnSubmit = form.find('[type=submit]');

    modal.on('hidden.bs.modal', function(){
        form.form('clear');
    });

    function addCategory(){
        modal.modal('show');
        submitUrl = '<?php echo e(route('admin.category.store')); ?>';
    }

    function editCategory(category_id){
        axios.get('<?php echo e(url('admin/kategori/load-data')); ?>/'+category_id)
        .then(function(response){
            form.form('load', response.data);
            modal.modal('show');

            submitUrl = '<?php echo e(url('admin/kategori')); ?>/'+category_id;
        });
    }

    function deleteCategory(category_id){

        var url_delete = '<?php echo e(url('admin/kategori/')); ?>/'+category_id;
        Swal.fire({
            icon: 'question',
            title: 'Hapus Kategori',
            text: 'Data tidak dapat dikembalikan setelah dihapus. Anda yakin ingin melanjutkan?',
            showCancelButton: true,
            cancelButtonText: '<i class="ri-close-line"></i> Batal',
            confirmButtonText: '<i class="ri-delete-bin-6-line"></i> Ya, Hapus',
            reverseButtons: true,
            buttonsStyling: false,
            customClass: {
                confirmButton: 'btn btn-danger ml-3',
                cancelButton: 'btn btn-default'
            },
            showLoaderOnConfirm: true,
            preConfirm: async() => {
                try {
                    const response = await fetch(url_delete, {
                        method: 'DELETE',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    if(!response.ok){
                        return Swal.showValidationMessage(`${JSON.stringify(await response.json())}`)
                    }

                    return response.json();

                }catch(error){
                    Swal.showValidationMessage(`Request failed: ${error}`);
                }
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then(result => {
            if(result.isConfirmed){
                if(result.value.status || result.value.success){
                    Swal.fire({'icon': 'success', 'title': result.value.message});
                    table.ajax.reload();
                }else{
                    Swal.fire({'icon': 'error', 'title': result.value.message});
                }
            }
        })
    }

    form.on('submit', function(e){
        e.preventDefault();
        var formdata = $(this).serialize();

        btnSubmit.indicator();

        axios
        .post(submitUrl, formdata)
        .then(function(response){
            if(!response.data.success){

            }else{
                Toast.fire({
                    icon: "success",
                    title: response.data.message
                });
                modal.modal('hide');
                table.ajax.reload();
            }
        })
        .catch(function(error){
            console.log(error);
        })
        .then(function(){
            btnSubmit.indicator('reset');
        })
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/admin/public_html/simantu.nttprov.go.id/resources/views/admin/kategori/index.blade.php ENDPATH**/ ?>