
<?php $__env->startSection('content'); ?>
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>Profile</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class=" breadcrumb-item"><a href="#">Home</a></li>
          <li class=" breadcrumb-item active">Profile</li>
        </ol>
      </div>
    </div>
  </div>
</div>
<div class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-6">
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">Data Pribadi</h3>
          </div>
          <div class="card-body">
            <form action="<?php echo e(route('admin.profile.update')); ?>" method="post">
              <?php echo csrf_field(); ?>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Nama Lengkap</label>
                <div class="col-lg-8">
                  <input type="text" name="name" class="form-control" value="<?php echo e($user->name); ?>">
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Jenis Kelamin</label>
                <div class="col-lg-8">
                  <div class="custom-control custom-radio custom-control-inline">
                    <input type="radio" id="radio1" name="sex" class="custom-control-input" value="male" <?php echo e($user->sex == "male" ? "checked" : ""); ?>>
                    <label class="custom-control-label" for="radio1">Laki-laki</label>
                  </div>
                  <div class="custom-control custom-radio custom-control-inline">
                    <input type="radio" id="radio2" name="sex" class="custom-control-input" value="female" <?php echo e($user->sex == "female" ? "checked" : ""); ?>>
                    <label class="custom-control-label" for="radio2">Perempuan</label>
                  </div>
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Unit Kerja</label>
                <div class="col-lg-8">
                  <select name="opd_id" class="form-control">
                  <option value="">Pilih Unit Kerja</option>
                  <?php $__currentLoopData = $opd; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($item->id); ?>" <?php echo e($user->opd_id == $item->id ? "selected" : ""); ?>><?php echo e($item->name); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                  </select>
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Pangkat/Golongan</label>
                <div class="col-lg-8">
                  <input type="text" name="grade_class" class="form-control" value="<?php echo e($user->grade_class); ?>">
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Jabatan</label>
                <div class="col-lg-8">
                  <input type="text" name="position" class="form-control" value="<?php echo e($user->position); ?>">
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">NIP</label>
                <div class="col-lg-8">
                  <input type="text" name="nip" class="form-control" value="<?php echo e($user->nip); ?>">
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Telepon</label>
                <div class="col-lg-8">
                  <input type="text" name="phone" class="form-control" value="<?php echo e($user->phone); ?>">
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Email</label>
                <div class="col-lg-8">
                  <input type="text" name="email" class="form-control" value="<?php echo e($user->email); ?>">
                </div>
              </div>

              <div class="row">
                <div class="col-lg-8 offset-lg-4 text-right">
                  <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
              </div>


            </form>
          </div>
        </div>
      </div>
      
      <div class="col-lg-6">
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">Ubah Password</h3>
          </div>
          <div class="card-body">
            <form action="<?php echo e(route('admin.users.change.password')); ?>" method="post">
              <?php echo csrf_field(); ?>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Password Lama</label>
                <div class="col-lg-8" data-password-field>
                  <input type="password" name="old_pass" class="form-control" required value="<?php echo e(old('old_pass') ?? ''); ?>">
                  <div class="password-btn" data-password-field-btn><span>Show</span><span>Hide</span></div>
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Password Baru</label>
                <div class="col-lg-8" data-password-field>
                  <input type="password" name="new_pass" class="form-control" required value="<?php echo e(old('new_pass') ?? ''); ?>">
                  <div class="password-btn" data-password-field-btn><span>Show</span><span>Hide</span></div>
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Konfirmasi Password </label>
                <div class="col-lg-8" data-password-field>
                  <input type="password" name="confirm_pass" class="form-control" required value="<?php echo e(old('confirm_pass') ?? ''); ?>">
                  <div class="password-btn" data-password-field-btn><span>Show</span><span>Hide</span></div>
                </div>
              </div>

              <div class="row">
                <div class="col-lg-8 offset-lg-4 text-right">
                  <button type="submit" class="btn btn-primary">Ubah Password</button>
                </div>
              </div>
              
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
  new inputShowPwd('new_pass');
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/admin/public_html/simantu.nttprov.go.id/resources/views/admin/users/profile.blade.php ENDPATH**/ ?>