
<?php $__env->startSection('content'); ?>
<div class="content-header">
	<div class="container-fluid">
		<div class="row mb-2">
			<div class="col-sm-6">
				<h1>Edit Berita</h1>
			</div>
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
					<li class=" breadcrumb-item"><a href="#">Home</a></li>
					<li class=" breadcrumb-item"><a href="<?php echo e(route('admin.berita')); ?>">Berita</a></li>
					<li class=" breadcrumb-item active">Edit Berita</li>
				</ol>
			</div>
		</div>
	</div>
</div>
<div class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h3 class="card-title">Edit Berita</h3>
					</div>
					<form action="<?php echo e(route('admin.berita.update')); ?>" method="post" autocomplete="off" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>
						<div class="card-body">

							<div class="form-group row">
								<label for="" class="col-form-label col-lg-2">Judul</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="title" required value="<?php echo e(old('title') ?? $post->title); ?>">
								</div>
							</div>

              <div class="form-group row">
                <label for="" class="col-form-label col-lg-2">Gambar</label>
                <div class="col-lg-3">
                  <div style="margin-bottom: 10px">
                    <img src="<?php echo e(url('uploads/foto-berita/'.$post->image) ?? URL::asset('img/noimage.jpg')); ?>" id="imageResult" style="width: 100%; min-height: 100px">
                  </div>
                  <input type="file" name="image" class="form-control" accept="image/*" onchange="readURL(this)">
                </div>
              </div>

              <div class="form-group row">
                <label for="" class="col-form-label col-lg-2">Isi Berita</label>
                <div class="col-lg-10">
                  <textarea name="content" class="form-control summernote"><?php echo e(old('content') ?? decodeContent($post->content)); ?></textarea>
                </div>
              </div> 

              <div class="form-group row">
								<label for="" class="col-form-label col-lg-2">Tanggal Berita</label>
								<div class="col-lg-2">
									<input type="text" class="form-control inputdate" data-inputmask-alias="datetime" data-inputmask-inputformat="yyyy-mm-dd" data-mask inputmode="numeric" name="post_date" required value="<?php echo e(old('post_date') ? old('post_date') : $post->post_date); ?>">
								</div>
							</div>

              <div class="form-group row">
								<label for="" class="col-form-label col-lg-2">Waktu Berita</label>
								<div class="col-lg-2">
									<input type="text" class="form-control" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:MM:ss" data-mask inputmode="numeric" name="post_time" required value="<?php echo e(old('post_time') ? old('post_time') : $post->post_time); ?>">
								</div>
							</div>
						</div>
            <div class="card-footer d-flex">
              <input type="hidden" name="id" value="<?php echo e($post->id); ?>">
              <a href="<?php echo e(route('admin.berita')); ?>" class="btn btn-default">Batal</a>
              <button type="submit" class="btn btn-primary ml-auto">Simpan</button>
            </div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
  $('.summernote').summernote();

  function readURL(input){
    if(input.files && input.files[0]){
      var reader = new FileReader();

      reader.onload = function(e){
        $('#imageResult').attr('src', e.target.result);
      };
      reader.readAsDataURL(input.files[0]);
    }
  }

  $('[data-mask]').inputmask();

  $('.select2').select2();
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/admin/public_html/simantu.nttprov.go.id/resources/views/admin/berita/edit.blade.php ENDPATH**/ ?>