
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Simantu | Request New Account</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo e(URL::asset('plugins/fontawesome-free/css/all.min.css')); ?>">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="<?php echo e(URL::asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
  <!-- Select2 -->
  <link rel="stylesheet" href="<?php echo e(URL::asset('plugins/select2/css/select2.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(URL::asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo e(URL::asset('dist/css/adminlte.min.css')); ?>">
</head>
<body style="background-image: url(<?php echo e(url('img/login-bg.jpg')); ?>); background-attachment: fixed; background-position: center; backdrop-filter:blur(5px);">

  <div style="background: rgba(255,255,255,0.1); position: absolute; height:100vh; width: 100vw; backdrop-filter: blur(5px)" class="d-flex flex-row justify-content-center align-items-center">
    <div class="container">
      <div class="row">
        <div class="col-lg-8 offset-lg-2">
          <div class="card overflow-hidden">
            <div class="card-body p-0">
              <div class="row">
                <div class="col-lg-6" style="background: #16325B">
                  <div class="p-3 d-lg-flex flex-column justify-content-center align-items-center h-100 d-none" style="">
                    <div class="text-center text-white-50">
                      <img src="<?php echo e(url("img/logo-ntt.png")); ?>" alt="" style="width: 125px; height: 125px;">
                      <h2 class=" text-bold text-white my-3">SIMANTU <small class=" text-white-50">v1.0</small></h2>
                      <p class="text-white-50">Sistem Informasi Manajemen Pengetahuan Pemerintah Provinsi Nusa Tenggara Timur</p>
                    </div>
                  </div>
                  <div class="d-lg-none text-center text-white-50 p-3">
                    <img src="<?php echo e(url("img/ntt.png")); ?>" alt="" style="width: 75px; height: 75px; margin-top: 100px">
                    <h2 class=" text-bold text-white my-3">SIMANTU <small class=" text-white-50">v1.0</small></h2>
                    <p class="text-white-50">Sistem Informasi Manajemen Pengetahuan Pemerintah Provinsi Nusa Tenggara Timur</p>
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="p-lg-5 p-3">
                    <p class="text-left">Register a new account.</p>

                    <form autocomplete="off" action="<?php echo e(route('request.account')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <input type="text" name="name" class="form-control" placeholder="Nama Lengkap">
                        </div>
                        <div class="mb-3">
                            <select name="opd_id" class="form-control select2">
                                <option value="">Pilih Unit Kerja</option>
                                <?php $__currentLoopData = $listOpd; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                                </select>
                        </div>
                        <div class="mb-3">
                            <input type="email" name="email" class="form-control" placeholder="Email">
                        </div>
                        <div class="mb-3">
                            <input type="password" name="password" class="form-control" placeholder="Password">
                        </div>
                            <button type="submit" class="btn btn-primary btn-block">
                                Register
                            </button>

                    </form>
                    <br>
                    <p class="mb-1">Sudah Punya akun?</p>
                    <p class="mb-0">
                    <a href="<?php echo e(route('login')); ?>" class="text-center">Login disini.</a>
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

<!-- jQuery -->
<script src="<?php echo e(URL::asset('plugins/jquery/jquery.min.js')); ?>"></script>
<!-- Bootstrap 4 -->
<script src="<?php echo e(URL::asset('plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
<!-- Select2 -->
<script src="<?php echo e(URL::asset('plugins/select2/js/select2.full.min.js')); ?>"></script>
<!-- AdminLTE App -->
<script src="<?php echo e(URL::asset('dist/js/adminlte.min.js')); ?>"></script>
<script>
    $('.select2').select2({
        placeholder: 'Pilih Unit Kerja'
    });
</script>
</body>
</html>
<?php /**PATH /home/admin/public_html/simantu.nttprov.go.id/resources/views/auth/request-new-account.blade.php ENDPATH**/ ?>