
<?php $__env->startSection('content'); ?>
<div class="content-header">
	<div class="container-fluid">
		<div class="row mb-2">
			<div class="col-sm-6">
				<h1>Data Berita</h1>
			</div>
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
					<li class=" breadcrumb-item"><a href="#">Home</a></li>
					<li class=" breadcrumb-item active">Berita</li>
				</ol>
			</div>
		</div>
	</div>
</div>
<div class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h3 class="card-title">Data Media</h3>
						<div class="card-tools">
							<div class="dropdown d-inline">
								<a href="#" class="btn btn-tool" data-toggle="dropdown">
									<i class="fas fa-cog"></i>
								</a>
								<div class="dropdown-menu dropdown-menu-right text-sm">
									<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create berita')): ?>
									<a href="<?php echo e(route('admin.berita.create')); ?>" class="dropdown-item">
										<i class="fas fa-plus-square text-muted  fa-fw mr-1"></i>
										Tambah Berita
									</a>
									<?php endif; ?>
									<a href="#" class="dropdown-item">
										<i class="fas fa-file-excel text-success mr-1 fa-fw"></i>
										Export Excel
									</a>
								</div>
							</div>
							<button type="button" onclick="table.ajax.reload()" class="btn btn-tool">
								<i class="fas fa-sync-alt"></i>
							</button>
							<button type="button" class="btn btn-tool" data-card-widget="maximize">
								<i class="fas fa-expand"></i>
							</button>
						</div>
					</div>
					<div class="card-body">
						<table class="table" style="width: 100%">
							<thead>
								<tr>
									<th></th>
									<th>Judul</th>
									<th>Gambar</th>
									<th>Isi</th>
									<th>Tgl. Publikasi</th>
									<th></th>
								</tr>
							</thead>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
	<script>
    var user_role = '<?php echo e(auth()->user()->getRoleNames()[0]); ?>';
    var user_id = '<?php echo e(auth()->user()->id); ?>';

		var table = $('.table').DataTable({
      processing: true,
      serverSide: true,
      responsive: true,
      ordering: false,
      ajax: {
        url: '<?php echo e(route('admin.berita.listdata')); ?>',
        type: 'GET',
        header: {
          headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')}
        }
      },
      columns: [
        {data: null, width: '20px', class: 'text-right', orderable: false, render: function(data, type, row, meta){
            return meta.row + meta.settings._iDisplayStart + 1;
        }},
        {data: 'title'},
        {data: null, width: '180px', render: function(data, row){
          let imageURL = `<?php echo e(url('uploads/foto-berita')); ?>/${data.image}`;
          return `<a href="${imageURL}"><img style="width: 150px;" src="${imageURL}"></a>`;
          // return 'a';
        }},
        {data: null, class:' text-wrap', render: function(data, row){
          return $('<div/>').html(data.content).text();
        }},
        {data: 'post_date', class: 'text-center', width: '100px'},
        {data: 'action', width: '20px'}
      ]
		})

    function hapusBerita(post_id){
			var url = `<?php echo e(url('admin/berita/delete')); ?>/${post_id}`;
			confirm('Hapus Berita', 'Anda yakin ingin menghapus berita ini?', url, function(){
				table.ajax.reload();
			})
		}
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Programming\Projek\simantu\resources\views/admin/berita/index.blade.php ENDPATH**/ ?>