<?php $__env->startSection('content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Video</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class=" breadcrumb-item"><a href="#">Home</a></li>
                    <li class=" breadcrumb-item active">Video</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Data Video</h3>
                        <div class=" card-tools">
                          <button class="btn btn-tool" onclick="table.ajax.reload()"><i class="fas fa-sync-alt"></i></button>
                          <button class="btn btn-tool mr-2" data-card-widget="maximize">
                            <i class="fas fa-expand"></i>
                          </button>
                          <button class="btn btn-sm btn-primary" onclick="addVideo()"><i class="fas fa-plus-square mr-2"></i>Tambah</button>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="table-opd" class="table table-hover">
                            <thead>
                                <th>#</th>
                                <th>Judul</th>
                                <th>Link</th>
                                <th></th>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="opd-modal">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Tambah Video</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="">
                        <div class="modal-body">
                            <div class="form-group mb-3">
                                <label for="" class="">Judul</label>
                                <input type="text" class="form-control" id="judul" name="title" required placeholder="Judul Video">
                            </div>
                            <div class="form-group">
                                <label for="" class="">Link</label>
                                <input type="text" class="form-control" name="link" required placeholder="Link Video">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary"><span>Simpan</span></button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    var table = $('#table-opd').DataTable({
        processing: true,
        serverSide: true,
        order: [1, 'asc'],
        ajax: {
            url: "<?php echo e(route('admin.videos.listdata')); ?>",
            type: "GET",
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')}
        },
        columns: [
            {data: null, width: '40px', orderable: false, render: function(data, type, row, meta){
                return meta.row + meta.settings._iDisplayStart + 1;
            }},
            {data: 'title'},
            {data: null, render: data => {
                return `<a href="${data.link}">${data.link}</a>`;
            }},
            {data: null, width: '50px', orderable: false, render: function(data, type, row){
                return `<div class='dropdown text-sm'>
                    <a href='#' data-toggle='dropdown' class='text-muted'>
                        <i class='fas fa-cog'></i>
                    </a>
                    <div class='dropdown-menu dropdown-menu-right'> 
                        <a href='#' class='dropdown-item' onclick='event.preventDefault(); editVideo(${data.id})'><i class='fas fa-edit mr-2'></i> Edit</a>
                        <a href='#' class='dropdown-item' onclick='event.preventDefault(); deleteVideo(${data.id})'><i class=' fas fa-trash-alt mr-2'></i> Hapus</a>
                    </div> 
                </div>`;
            }}
        ]
    });

    var submitUrl = '';
    var modal = $('#opd-modal');
    var form = modal.find('form');
    var btnSubmit = form.find('[type=submit]');

    modal.on('hidden.bs.modal', function(){
        form.form('clear');
    });

    function addVideo(){
        modal.modal('show');
        submitUrl = '<?php echo e(route('admin.videos.store')); ?>';
    }

    function editVideo(video_id){
        axios.get('<?php echo e(url('admin/videos/load-data')); ?>/'+video_id)
        .then(function(response){
            form.form('load', response.data);
            modal.modal('show');

            submitUrl = '<?php echo e(url('admin/videos')); ?>/'+video_id;
        });
    }

    function deleteVideo(video_id){

        var url_delete = '<?php echo e(url('admin/videos/')); ?>/'+video_id;
        Swal.fire({
            icon: 'question',
            title: 'Hapus Video',
            text: 'Data tidak dapat dikembalikan setelah dihapus. Anda yakin ingin melanjutkan?',
            showCancelButton: true,
            cancelButtonText: '<i class="ri-close-line"></i> Batal',
            confirmButtonText: '<i class="ri-delete-bin-6-line"></i> Ya, Hapus',
            reverseButtons: true,
            buttonsStyling: false,
            customClass: {
                confirmButton: 'btn btn-danger ml-3',
                cancelButton: 'btn btn-default'
            },
            showLoaderOnConfirm: true,
            preConfirm: async() => {
                try {
                    const response = await fetch(url_delete, {
                        method: 'DELETE',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    if(!response.ok){
                        return Swal.showValidationMessage(`${JSON.stringify(await response.json())}`)
                    }

                    return response.json();

                }catch(error){
                    Swal.showValidationMessage(`Request failed: ${error}`);
                }
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then(result => {
            if(result.isConfirmed){
                if(result.value.status || result.value.success){
                    Swal.fire({'icon': 'success', 'title': result.value.message});
                    table.ajax.reload();
                }else{
                    Swal.fire({'icon': 'error', 'title': result.value.message});
                }
            }
        })
    }

    form.on('submit', function(e){
        e.preventDefault();
        var formdata = $(this).serialize();

        btnSubmit.indicator();

        axios
        .post(submitUrl, formdata)
        .then(function(response){
            if(!response.data.success){

            }else{
                Toast.fire({
                    icon: "success",
                    title: response.data.message
                });
                modal.modal('hide');
                table.ajax.reload();
            }
        })
        .catch(function(error){
            console.log(error);
        })
        .then(function(){
            btnSubmit.indicator('reset');
        })
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/admin/public_html/simantu.nttprov.go.id/resources/views/admin/videos/index.blade.php ENDPATH**/ ?>