

<?php $__env->startSection('content'); ?>
<div class="content-header">
	<div class="container-fluid">
		<div class="row mb-2">
			<div class="col-sm-6">
				<h1>Pengetahuan Umum</h1>
			</div>
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
					<li class=" breadcrumb-item"><a href="#">Home</a></li>
					<li class=" breadcrumb-item active">Pengetahuan Umum</li>
				</ol>
			</div>
		</div>
	</div>
</div>
<div class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h3 class="card-title">Data Pengetahuan Umum</h3>
						<div class="card-tools">
							<div class="dropdown d-inline">
								<a href="#" class="btn btn-tool" data-toggle="dropdown">
									<i class="fas fa-cog"></i>
								</a>
								<div class="dropdown-menu dropdown-menu-right text-sm">
									<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create media')): ?>
									<a href="<?php echo e(route('admin.media.create')); ?>" class="dropdown-item">
										<i class="fas fa-layers-plus text-primary fa-fw mr-1"></i>
										Tambah Media
									</a>
									<?php endif; ?> 
								</div>
							</div>
							<button type="button" onclick="table.ajax.reload()" class="btn btn-tool">
								<i class="fas fa-sync-alt"></i>
							</button>
							<button type="button" class="btn btn-tool" data-card-widget="maximize">
								<i class="fas fa-expand"></i>
							</button>
						</div>
					</div>
					<div class="card-body">
						<table id="table" class="table" style="width: 100%">
							<thead>
								<tr> 
                                    <th>Pengetahuan</th>
                                    <th>Publikasi</th>
									<th></th>
								</tr>
							</thead>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
	<script>
		var table = $('#table').DataTable({
			serverSide: true,
			processing: true, 
			ordering: false,
			ajax: {
				url: '<?php echo e(route('admin.media.listdata')); ?>',
				type: 'GET', 
			}, 
			columns: [  
                {data: null, render: function(data){
                    var mediaUrl = '<?php echo e(url("uploads/media")); ?>/' + data.media;
				    if(!data.media)
					    mediaUrl = data.link;
					    
                    return `
                    <div class='text-bold'><a href='${mediaUrl}'>${data.title}</a></div>
                    <div class='text-muted'>${data.description}</div>
                    <div style='font-size: 13px' class='text-bold text-muted'>
                        <i class='fas fa-building mr-2'></i> ${data.opd_name} <i class='fas fa-tags mx-2'></i>${data.tags} <br>
                        <i class='fas fa-user mr-2'></i> ${data.writer} <i class='fas fa-users mx-2'></i> ${data.contributor} <br>
                        <i class='fas fa-layer-group mr-2'></i> ${data.category_name}
                    </div> 
                    `;
                }},
                {data: null, class: 'text-sm text-muted', render: function(data){
                    return `
                    ${data.visibility} <br>
                    ${data.publication_date}
                    `;  
                }},
				{data: null, width: '50px', orderable: false, render: function(data, type, row){
					return `<div class='dropdown'>
						<a href='#' data-toggle='dropdown' class='text-secondary text-sm'>
							<i class='fas fa-cog'></i>
						</a>
						<div class='dropdown-menu dropdown-menu-right text-sm'> 
							<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update media')): ?>
							<a href='<?php echo e(url('admin/media/edit')); ?>/${data.id}' class='dropdown-item'><i class='fas fa-edit mr-2'></i> Edit</a>
							<?php endif; ?>
							<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete media')): ?>
							<a href='#' class='dropdown-item' onclick="event.preventDefault(); deleteMedia(${data.id})"><i class='fas fa-trash-alt mr-2'></i> Hapus</a>
							<?php endif; ?>
						</div> 
					</div>`;
				}}
			]
		});

		function deleteMedia(category_id){

			var url_delete = '<?php echo e(url('admin/media/delete')); ?>/'+category_id;
			Swal.fire({
				icon: 'question',
				title: 'Hapus Media',
				text: 'Data tidak dapat dikembalikan setelah dihapus. Anda yakin ingin melanjutkan?',
				showCancelButton: true,
				cancelButtonText: '<i class="ri-close-line"></i> Batal',
				confirmButtonText: '<i class="ri-delete-bin-6-line"></i> Ya, Hapus',
				reverseButtons: true,
				buttonsStyling: false,
				customClass: {
					confirmButton: 'btn btn-danger ml-3',
					cancelButton: 'btn btn-default'
				},
				showLoaderOnConfirm: true,
				preConfirm: async() => {
					try {
						const response = await fetch(url_delete, {
							method: 'DELETE',
							headers: {
								'Content-Type': 'application/json',
								'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
							}
						});

						if(!response.ok){
							return Swal.showValidationMessage(`${JSON.stringify(await response.json())}`)
						}

						return response.json();

					}catch(error){
						Swal.showValidationMessage(`Request failed: ${error}`);
					}
				},
				allowOutsideClick: () => !Swal.isLoading()
			}).then(result => {
				if(result.isConfirmed){
					if(result.value.status || result.value.success){
						Swal.fire({'icon': 'success', 'title': result.value.message});
						table.ajax.reload();
					}else{
						Swal.fire({'icon': 'error', 'title': result.value.message});
					}
				}
			})
		}
		
		$('ul#sidebar li#pengetahuan > a').addClass('active');
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/admin/public_html/simantu.nttprov.go.id/resources/views/admin/media/index.blade.php ENDPATH**/ ?>