
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Simantu | Request New Account</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo e(URL::asset('plugins/fontawesome-free/css/all.min.css')); ?>">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="<?php echo e(URL::asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
  <!-- Select2 -->
  <link rel="stylesheet" href="<?php echo e(URL::asset('plugins/select2/css/select2.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(URL::asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo e(URL::asset('dist/css/adminlte.min.css')); ?>">
</head>
<body class="hold-transition login-page">
<div class="login-box">
    
        <!-- /.login-logo -->
        <div class="card card-outline card-primary">
            <div class="card-header text-center">
            <a href="../../index2.html" class="">
                <b class="h1" style="color: black; font-weight: bold;">Simantu</b>
                <br>
                <p style="margin: 0; color: #333">Sistem Informasi Manajemen Pengetahuan</p>
            </a>
            </div>
            <div class="card-body">
            <p class="text-left">Register a new account.</p>

            <form autocomplete="off" action="<?php echo e(route('request.account')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="mb-3">
                    <input type="text" name="name" class="form-control" placeholder="Nama Lengkap">
                </div>
                <div class="mb-3">
                    <select name="opd_id" class="form-control select2">
                        <option value="">Pilih Unit Kerja</option>
                        <?php $__currentLoopData = $listOpd; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                        </select>
                </div>
                <div class="mb-3">
                    <input type="email" name="email" class="form-control" placeholder="Email">
                </div>
                <div class="mb-3">
                    <input type="password" name="password" class="form-control" placeholder="Password">
                </div>
                    <button type="submit" class="btn btn-primary btn-block">
                        Register
                    </button>

            </form>
            <br>
            <p class="mb-1">Sudah Punya akun?</p>
            <p class="mb-0">
            <a href="<?php echo e(route('login')); ?>" class="text-center">Login disini.</a>
            </p>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    
</div>
<!-- /.login-box -->

<!-- jQuery -->
<script src="<?php echo e(URL::asset('plugins/jquery/jquery.min.js')); ?>"></script>
<!-- Bootstrap 4 -->
<script src="<?php echo e(URL::asset('plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
<!-- Select2 -->
<script src="<?php echo e(URL::asset('plugins/select2/js/select2.full.min.js')); ?>"></script>
<!-- AdminLTE App -->
<script src="<?php echo e(URL::asset('dist/js/adminlte.min.js')); ?>"></script>
<script>
    $('.select2').select2({
        placeholder: 'Pilih Unit Kerja'
    });
</script>
</body>
</html>
<?php /**PATH D:\Programming\Projek\simantu\resources\views/auth/request-new-account.blade.php ENDPATH**/ ?>