
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>AdminLTE 3 | Log in (v2)</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo e(URL::asset('plugins/fontawesome-free/css/all.min.css')); ?>">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="<?php echo e(URL::asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo e(URL::asset('dist/css/adminlte.min.css')); ?>">
</head>
<body class="hold-transition login-page">
<div class="login-box">
  <!-- /.login-logo -->
  <div class="card card-outline card-primary">
    <div class="card-header text-center">
      <a href="../../index2.html" class="">
        <b class="h1" style="color: black; font-weight: bold;">Simantu</b>
        <br>
        <p style="margin: 0; color: #333">Sistem Informasi Manajemen Pengetahuan</p>
    </a>
    </div>
    <div class="card-body">
      <p class="login-box-msg">Sign in to start your session</p>

      <form action="<?php echo e(route('login')); ?>" method="post">
        <?php echo csrf_field(); ?>
        <div class="mb-3">
            <div class="input-group">
                <input type="email" name="email" class="form-control" placeholder="Email">
                <div class="input-group-append">
                    <div class="input-group-text">
                    <span class="fas fa-envelope"></span>
                    </div>
                </div>
            </div>
            <?php if($errors->get('email')): ?>
            <span class='text-danger help-block'><?php echo e($errors->get('email')[0]); ?></span>
            <?php endif; ?>
        </div>
        <div class="mb-3">
            <div class="input-group">
                <input type="password" name="password" class="form-control" placeholder="Password">
                <div class="input-group-append">
                    <div class="input-group-text">
                    <span class="fas fa-lock"></span>
                    </div>
                </div>
            </div>
            <?php if($errors->get('password')): ?>
            <span class='text-danger help-block'><?php echo e($errors->get('password')[0]); ?></span>
            <?php endif; ?>
        </div>
        <button type="submit" class="btn btn-primary btn-block">Masuk</button>
      </form>
      <br>
      <p class="mb-1">Belum Punya akun?</p>
      <p class="mb-0">
      <a href="<?php echo e(route('daftar')); ?>" class="text-center">Daftar disini.</a>
      </p>
      <!-- /.social-auth-links -->
    </div>
    <!-- /.card-body -->
  </div>
  <!-- /.card -->
</div>
<!-- /.login-box -->

<!-- jQuery -->
<script src="<?php echo e(URL::asset('plugins/jquery/jquery.min.js')); ?>"></script>
<!-- Bootstrap 4 -->
<script src="<?php echo e(URL::asset('plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
<!-- AdminLTE App -->
<script src="<?php echo e(URL::asset('dist/js/adminlte.min.js')); ?>"></script>
</body>
</html>
<?php /**PATH D:\Programming\Projek\simantu\resources\views/login.blade.php ENDPATH**/ ?>