

<?php $__env->startSection('content'); ?>
<div class="content-header">
	<div class="container-fluid">
		<div class="row mb-2">
			<div class="col-sm-6">
				<h1>Edit User</h1>
			</div>
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
					<li class=" breadcrumb-item"><a href="#">Home</a></li>
					<li class=" breadcrumb-item"><a href="<?php echo e(route('admin.users')); ?>">Users</a></li>
					<li class=" breadcrumb-item active">Edit User</li>
				</ol>
			</div>
		</div>
	</div>
</div>
<div class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h3 class="card-title">Edit User</h3>
					</div>
					<form action="<?php echo e(route('admin.users.update')); ?>" method="POST">
						<?php echo csrf_field(); ?>
						<div class="card-body">

							<div class="form-group row">
								<label class="col-form-label col-lg-2">Nama Lengkap</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="name" required="required" value="<?php echo e($user->name); ?>">
								</div>
							</div>
							
							<div class="form-group row">
								<label class="col-form-label col-lg-2">Jenis Kelamin</label>
								<div class="col-lg-2">
									<select name="sex" class="form-control" required>
										<?php $__currentLoopData = ['male' => 'Laki-laki', 'female' => 'Perempuan']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option value="<?php echo e($key); ?>" <?php echo e($key == $user->sex ? 'selected' : ''); ?>><?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
							</div>

							<div class="form-group row">
								<label class="col-form-label col-lg-2">Unit Kerja</label>
								<div class="col-lg-10">
									<select name="opd_id" class="form-control" required>
										<?php $__currentLoopData = $opd; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option value="<?php echo e($item->id); ?>" <?php echo e($item->id == $user->opd_id ? 'selected' : ''); ?>><?php echo e($item->name); ?></option>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
							</div>

							<div class="form-group row">
								<label class="col-form-label col-lg-2">Pangkat / Golongan</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="grade_class" required="required" value="<?php echo e($user->grade_class); ?>">
								</div>
							</div>

							<div class="form-group row">
								<label class="col-form-label col-lg-2">Jabatan</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="position" required="required" value="<?php echo e($user->position); ?>">
								</div>
							</div>

							<div class="form-group row">
								<label class="col-form-label col-lg-2">NIP</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="nip" required="required" value="<?php echo e($user->nip); ?>">
								</div>
							</div>

							<div class="form-group row">
								<label class="col-form-label col-lg-2">Email</label>
								<div class="col-lg-10">
									<input type="email" class="form-control" name="email" required="required" value="<?php echo e($user->email); ?>">
								</div>
							</div>

							<div class="form-group row">
								<label class="col-form-label col-lg-2">Telepon</label>
								<div class="col-lg-4">
									<input type="text" class="form-control" name="phone" required="required" value="<?php echo e($user->phone); ?>">
								</div>
							</div>

							<div class="form-group row">
								<label class="col-form-label col-lg-2">Password</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="password" value="">
									<span class="text-muted text-sm">Tinggalkan kosong jika tidak diubah.</span>
								</div>
							</div>

						</div>
						<div class="card-footer d-flex">
							<input type="hidden" name="id" value="<?php echo e($user->id); ?>">
							<a href="<?php echo e(route('admin.users')); ?>" class="btn btn-default">Batal</a>
							<button type="submit" class="btn btn-primary ml-auto">Simpan</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
	
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/admin/public_html/simantu.nttprov.go.id/resources/views/admin/users/edit.blade.php ENDPATH**/ ?>