

<?php $__env->startSection('content'); ?>
<div class="content-header">
	<div class="container-fluid">
		<div class="row mb-2">
			<div class="col-sm-6">
				<h1>Data Media</h1>
			</div>
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
					<li class=" breadcrumb-item"><a href="#">Home</a></li>
					<li class=" breadcrumb-item active">Media</li>
				</ol>
			</div>
		</div>
	</div>
</div>
<div class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h3 class="card-title">Data Media</h3>
						<div class="card-tools">
							<div class="dropdown d-inline">
								<a href="#" class="btn btn-tool" data-toggle="dropdown">
									<i class="fas fa-cog"></i>
								</a>
								<div class="dropdown-menu dropdown-menu-right text-sm">
									<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create media')): ?>
									<a href="<?php echo e(route('admin.media.create')); ?>" class="dropdown-item">
										<i class="fas fa-layers-plus text-primary fa-fw mr-1"></i>
										Tambah Media
									</a>
									<?php endif; ?>
									<div class="dropdown-divider"></div>
									<a href="#" class="dropdown-item">
										<i class="fas fa-file-excel text-success mr-1 fa-fw"></i>
										Export Excel
									</a>
								</div>
							</div>
							<button type="button" onclick="table.ajax.reload()" class="btn btn-tool">
								<i class="fas fa-sync-alt"></i>
							</button>
							<button type="button" class="btn btn-tool" data-card-widget="maximize">
								<i class="fas fa-expand"></i>
							</button>
						</div>
					</div>
					<div class="card-body">
						<table class="table" style="width: 100%">
							<thead>
								<tr>
									<th>No</th>
									<th>Judul</th>
									<th>Deskripsi</th>
									<th>Penulis</th>
									<th>Link</th>
									<th>Kontributor</th>
									<th>Label / Tag</th>
									<th>Status Publikasi</th>
									<th>Tanggal Publikasi</th>
									
								</tr>
							</thead>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
	<script>
		var table = $('.table').DataTable({
			serverSide: true,
			processing: true,
			responsive: true,
			order: [1, 'asc'],
			ajax: {
				url: '<?php echo e(route('admin.media.listdata')); ?>',
				type: 'GET',
				// header: {
				// 	'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				// }
			},
			columns: [
				{data: null, width: '50px', class: 'text-right', orderable: false, render: function(data, type, row, meta){
					return meta.row + meta.settings._iDisplayStart + 1;
				}},
				{data: 'title'},
				{data: 'description'},
				{data: 'writer'},
				{data: null, render: function(data){
					return `<a href='${data.link}'>${data.link}</a>`
				}},
				{data: 'contributor'},	
				{data: 'tags'},
				{data: null, render: function(data, type, row){
					if(data.visibility == 0)
						return "Terbatas";
					else 
						return "Umum";
				}},
				{data: 'publication_date'},
				{data: null, width: '50px', orderable: false, render: function(data, type, row){
					return `<div class='dropdown'>
						<a href='#' data-toggle='dropdown' class='text-secondary text-sm'>
							<i class='fas fa-cog'></i>
						</a>
						<div class='dropdown-menu dropdown-menu-right text-sm'> 
							<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update media')): ?>
							<a href='<?php echo e(url('admin/media/edit')); ?>/${data.id}' class='dropdown-item'><i class='fas fa-edit mr-2'></i> Edit</a>
							<?php endif; ?>
							<div class='dropdown-divider'></div>
							<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete opd')): ?>
							<a href='#' class='dropdown-item' onclick="event.preventDefault(); deleteMedia(${data.id})"><i class='fas fa-trash-alt mr-2'></i> Hapus</a>
							<?php endif; ?>
						</div> 
					</div>`;
				}}
			]
		});

		function deleteMedia(category_id){

			var url_delete = '<?php echo e(url('admin/media/delete')); ?>/'+category_id;
			Swal.fire({
				icon: 'question',
				title: 'Hapus Media',
				text: 'Data tidak dapat dikembalikan setelah dihapus. Anda yakin ingin melanjutkan?',
				showCancelButton: true,
				cancelButtonText: '<i class="ri-close-line"></i> Batal',
				confirmButtonText: '<i class="ri-delete-bin-6-line"></i> Ya, Hapus',
				reverseButtons: true,
				buttonsStyling: false,
				customClass: {
					confirmButton: 'btn btn-danger ml-3',
					cancelButton: 'btn btn-default'
				},
				showLoaderOnConfirm: true,
				preConfirm: async() => {
					try {
						const response = await fetch(url_delete, {
							method: 'DELETE',
							headers: {
								'Content-Type': 'application/json',
								'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
							}
						});

						if(!response.ok){
							return Swal.showValidationMessage(`${JSON.stringify(await response.json())}`)
						}

						return response.json();

					}catch(error){
						Swal.showValidationMessage(`Request failed: ${error}`);
					}
				},
				allowOutsideClick: () => !Swal.isLoading()
			}).then(result => {
				if(result.isConfirmed){
					if(result.value.status || result.value.success){
						Swal.fire({'icon': 'success', 'title': result.value.message});
						table.ajax.reload();
					}else{
						Swal.fire({'icon': 'error', 'title': result.value.message});
					}
				}
			})
		}
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Programming\Projek\simantu\resources\views/admin/media/index.blade.php ENDPATH**/ ?>