<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>SPBE NTT</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome Icons -->
  <link rel="stylesheet" href="<?php echo e(URL::asset('plugins/fontawesome-free/css/all.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(URL::asset('plugins/bootstrap-icons/bootstrap-icons.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(URL::asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(URL::asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(URL::asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css')); ?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo e(URL::asset('dist/css/adminlte.min.css')); ?>">
  <style>
  	
  </style>
</head>
<body class="hold-transition layout-top-nav">
<div class="wrapper">

	<div class="header bg-dark" style="border-bottom: 1px solid rgba(255,255,255,.10);">
		<div class="container-fluid">
			<div class="d-flex flex-row py-3 px-2">
				<div class="d-flex flex-row">
					<img alt="" src="<?php echo e(URL::asset("img/ntt.png")); ?>" style="width: 52px; height: 52px;">
					<div class="ml-3">
						<h4 class="m-0 font-bold" style="letter-spacing: 2px; font-weight: bold">SIMANTU</h4>
						<h6 class="m-0 fw-bold" style="font-size: 11px; font-weight: normal;">SISTEM INFORMASI MANEJEMEN PENGETAHUAN <br> PROVINSI NUSA TENGGARA TIMUR</h6>
					</div>
				</div>
			</div>
		</div>
	</div>
  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand-md navbar-light navbar-dark sticky-top"> 
		<div class="container-fluid">
		  

		  <button class="navbar-toggler order-1" type="button" data-toggle="collapse" data-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
			<span class="navbar-toggler-icon"></span>
		  </button>

		  <div class="collapse navbar-collapse order-3" id="navbarCollapse">
				<!-- Left navbar links -->
				<ul class="navbar-nav">
				  <li class="nav-item">
					<a href="index3.html" class="nav-link">Evaluasi</a>
				  </li>
				  <li class="nav-item">
					<a href="#" class="nav-link">Aplikasi</a>
				  </li>
				</ul>
		  </div>

		  <!-- Right navbar links -->
		  <ul class="order-1 order-md-3 navbar-nav navbar-no-expand ml-auto">
			<li class="nav-item">
			  <a class="nav-link" data-widget="control-sidebar" data-slide="true" href="#" role="button">
				<i class="fas fa-th-large"></i>
			  </a>
			</li>
			<li class="nav-item">
				<a href="<?php echo e(url('login')); ?>" class="nav-link" role="button">
					<i class="bi bi-person-circle mr-2"></i>
					Login
				</a>
			</li>
		  </ul>
		</div>
  </nav>
  <!-- /.navbar -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper py-3">

  	<br> 

		<!-- Main content -->
		<div class="content">
		  <div class="container-fluid">
				<div class="card">
					<div class="card-header">
						<h4 class="card-title">Data Pengetahuan SPBE</h4>
					</div>
					<div class="card-body">
						<form action="">
							<div class="form-group row">
								<label for="" class="col-sm-2 col-form-label">Unit Kerja</label>
								<div class="col-sm-10">
									<select class="form-control">
										<option value="">Pilih OPD</option>
										<?php 
										$daftar_opd = [
											'Dinas Pendidikan dan Kebudayaan Provinsi NTT',
											'Dinas Pemuda dan Olahraga Provinsi NTT',
											'Dinas Pariwisata dan Ekonomi Kreatif Provinsi NTT',
											'Biro Organisasi Setda Provinsi NTT'
										];
										?>
										<?php $__currentLoopData = $daftar_opd; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
							</div>
							<div class="form-group row">
								<label for="" class="col-sm-2 col-form-label">Kategori</label>
								<div class="col-sm-10">
									<select class="form-control">
										<option value="">Pilih Kategori</option>
										<?php
										$daftar_kategori = [
											'Tata Kelola SPBE',
											'Manajemen SPBE',
											'Layanan SPBE',
											'Infrastruktur SPBE',
											'Aplikasi',
											'Keamanan Informasi',
											'Audit Teknologi Informasi'
										];
										?>
										<?php $__currentLoopData = $daftar_kategori; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
							</div>
							<div class="form-group row">
								<label for="" class="col-sm-2 col-form-label">Tag</label>
								<div class="col-sm-10">
									<input type="text" class="form-control">
								</div>
							</div>
							<button class="btn btn-primary">Tampilkan</button>
						</form>
						<br>
						<table class="table">
							<thead>
								<tr>
									<th class="text-right" style="width: 30px;">No</th>
									<th>Judul</th>
									<th>Pembuat</th>
									<th>OPD</th>
									<th>Kategori</th>
									<th>Deskripsi</th>
									<th style="width: 150px;">Terahkir Update</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td class="text-right">1</td>
									<td><a href="">Keputusan Gubernur NTT Nomor 124/kep/HK/2024</a></td>
									<td>Frans Frists Gerald Bessie, ST., MM</td>
									<td>Dinas Komunikasi dan Informatika Provinsi NTT</td>
									<td>Tata Kelola</td>
									<td>Tentang Tim Koordinasi sistem pemerintahan berbasis elektronik di lingkungan Pemerinrtah Provinsi NTT</td>
									<td>24-08-2024 16:02:12</td>
								</tr>
								<tr>
									<td class="text-right">2</td>
									<td><a href="">Peraturan Gubernur Nusa Tenggara Timur no.72 tahun 2002</a></td>
									<td>Frans Frists Gerald Bessie, ST., MM</td>
									<td>Dinas Komunikasi dan Informatika Provinsi NTT</td>
									<td>Tata Kelola</td>
									<td>Tentang arsitektur  sistem pemerintahan berbasis elektronik Pemerintah Provinsi Tenggara Timur</td>
									<td>22-08-2024 15:34:25</td>
								</tr>
								<tr>
									<td class="text-right">3</td>
									<td><a href="">Pergub 76 2022 tahun 2022</a></td>
									<td>Frans Frists Gerald Bessie, ST., MM</td>
									<td>Dinas Komunikasi dan Informatika Provinsi NTT</td>
									<td>Tata Kelola</td>
									<td>Pedoman pemabgunan dan pengembangan aplikasi sistem pemerintahan berbasis elektronik pemerintah Provinsi NTT</td>
									<td>21-08-2024 17:21:25</td>
								</tr>
								<tr>
									<td class="text-right">4</td>
									<td><a href="">Surat Edaran Sekda Nomor : BU.100.3.4/02/Kominfo/2024</a></td>
									<td>Frans Frists Gerald Bessie, ST., MM</td>
									<td>Dinas Komunikasi dan Informatika Provinsi NTT</td>
									<td>Tata Kelola</td>
									<td>Standarisasi tenologi informasi dan komunikasi (TIK) lingkup pemerintah provinsi NTT</td>
									<td>21-08-2024 15:21:25</td>
								</tr>
								<tr>
									<td class="text-right">5</td>
									<td><a href="">Peraturan Gubernur Nusa Tenggara Timur Nomor 32  thn 2023</a></td>
									<td>Frans Frists Gerald Bessie, ST., MM</td>
									<td>Dinas Komunikasi dan Informatika Provinsi NTT</td>
									<td>Tata Kelola</td>
									<td>Sistem Pemerintahan Berbasis Elektronik Pemerintah Provinsi NTT</td>
									<td>20-08-2024 10:42:07</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
		  </div><!-- /.container-fluid -->
		</div>
		<!-- /.content -->
  </div>
  <!-- /.content-wrapper -->


  <!-- Main Footer -->
  <footer class="main-footer">
	<!-- To the right -->
	<div class="float-right d-none d-sm-inline">
	  V0.0.1
	</div>
	<!-- Default to the left -->
	<strong>Copyright &copy; 2020 - <?php echo e(date('Y')); ?> &nbsp;&nbsp; <a href="https://adminlte.io">SPBE NTT</a>.</strong> 
  </footer>
</div>
<!-- ./wrapper -->

<!-- REQUIRED SCRIPTS -->

<!-- jQuery -->
<script src="<?php echo e(URL::asset('plugins/jquery/jquery.min.js')); ?>"></script>
<!-- Bootstrap 4 -->
<script src="<?php echo e(URL::asset('plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
<!-- AdminLTE App -->
<script src="<?php echo e(URL::asset('dist/js/adminlte.min.js')); ?>"></script> 
<script>
	$('.table').DataTable({
		ordering: false
	})
</script>
</body>
</html>
<?php /**PATH D:\Programming\Projek\simantu\resources\views/welcome.blade.php ENDPATH**/ ?>