

<?php $__env->startSection('content'); ?>
<div class="content-header">
	<div class="container-fluid">
		<div class="row mb-2">
			<div class="col-sm-6">
				<h1>Data Media</h1>
			</div>
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
					<li class=" breadcrumb-item"><a href="#">Home</a></li>
					<li class=" breadcrumb-item"><a href="<?php echo e(route('admin.media')); ?>">Media</a></li>
					<li class=" breadcrumb-item active">Tambah Media</li>
				</ol>
			</div>
		</div>
	</div>
</div>
<div class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h3 class="card-title">Tambah Media</h3>
					</div>
					<div class="card-body">
						<form action="<?php echo e(route('admin.media.store')); ?>" method="post">
							<?php echo csrf_field(); ?>
							<div class="form-group row">
								<label for="title" class="col-form-label col-lg-2">Judul</label>
								<div class="col-lg-10">
									<input type="text" id="title" name="title" class="form-control" required="" placeholder="Judul Dokumen / Media">
								</div>
							</div>
							<div class="form-group row">
								<label for="writer" class="col-form-label col-lg-2">
									Penulis
									<a href="#" data-toggle="tooltip" title="Penulis atau author adalah nama penulis, penyusun, atau pembuat pengetahuan SPBE"><i class="fas fa-info-circle"></i></a>
								</label>
								<div class="col-lg-10">
									<input type="text" id="writer" name="writer" class="form-control" required="" placeholder="">
								</div>
							</div>
							<div class="form-group row">
								<label for="writer" class="col-form-label col-lg-2">Instansi</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="opd_id" disabled value="<?php echo e($opd->name); ?>">
								</div>
							</div>
							<div class="form-group row">
								<label for="description" class="col-form-label col-lg-2">Deskripsi</label>
								<div class="col-lg-10">
									<textarea name="description" id="description" class="form-control"></textarea>
								</div>
							</div>
							<div class="form-group row">
								<label for="category" class="col-form-label col-lg-2">Lingkup SPBE</label>
								<div class="col-lg-10">
									<select name="category_id" id="category" class="form-control" required>
										<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
							</div>
							<div class="form-group row">
								<label for="media" class="col-form-label col-lg-2">Media</label>
								<div class="col-lg-10">
									<input type="text" id="media" name="link" class="form-control" required="" placeholder="https://">
									<span class="text-muted text-sm font-semibold">
										Masukkan link media anda. Contoh: Google Drive, Web, dll.
									</span>
								</div>
							</div>
							<div class="form-group row">
								<label for="contributor" class="col-form-label col-lg-2">
									Kontributor
									<a href="#" data-toggle="tooltip" title="Kontributor atau nama pendukung yang memberikan kontribusi pada penulis dalam menyusun pengetahuan SPBE. Kontributor bisa berjumlah lebih dari satu."><i class="fas fa-info-circle"></i></a>
								</label>
								<div class="col-lg-10">
									<textarea id="contributor" class="form-control" name="contributor" required="" placeholder=""></textarea>
								</div>
							</div>
							<div class="form-group row">
								<label for="tags" class="col-form-label col-lg-2">
									Kata Kunci
									<a href="#" data-toggle="tooltip" title="Kata kunci dari pengetahuan SPBE untuk memudahkan pencarian kembali."><i class="fas fa-info-circle"></i></a>
								</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="tags" id="tags">
									<span class="text-sm text-muted">Pisahkan dengan tanda <strong>;</strong></span>
								</div>
							</div>
							<div class="form-group row">
								<label for="visibility" class="col-lg-2 col-form-label">Status Publikasi</label>
								<div class="col-lg-10">
									<select name="visibility" id="visibility" class="form-control">
										<option value="1">Umum</option>
										<option value="0">Terbatas</option>
									</select>
								</div>
							</div>
							<div class="form-group row">
								<label for="pubdate" class="col-form-label col-lg-2">Tanggal Publikasi</label>
								<div class="col-lg-10">
									<input type="text" id="pubdate" name="publication_date" class="form-control datepicker" required="" placeholder="">
								</div>
							</div>
							<div class="d-flex flex-row border-top py-3">
								<a href="<?php echo e(route('admin.media')); ?>" onclick="return confirm('Anda yakin ingin meninggalkan halaman ini?')" class="btn btn-default">Batal</a>
								<button type="submit" class="btn btn-primary ml-auto">Tambah</button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
	<script>
		$('.datepicker').daterangepicker({
			singleDatePicker: true,
			showDropdowns: true,
			locale: {
				format: 'YYYY-MM-DD'
			}
		})
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Programming\Projek\simantu\resources\views/admin/media/create.blade.php ENDPATH**/ ?>