<?php

use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\MediaController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\OpdController;
use App\Http\Controllers\Admin\VideoController;
use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Admin\PostController;
use Illuminate\Support\Facades\Route;

Route::get('/', [HomeController::class, 'index'])->name('user.home');
Route::get('daftar-media', [HomeController::class, 'daftarMedia'])->name('user.daftar.media');

Route::get('daftar', [AuthenticatedSessionController::class, 'requestNewAccount'])->name('daftar');
Route::post('request-account', [AuthenticatedSessionController::class, 'requestAccount'])->name('request.account');
Route::get('register-status', [AuthenticatedSessionController::class, 'registerStatus'])->name('register.status');

Route::get('berita', [HomeController::class, 'posts'])->name('berita');
Route::get('berita/view/{slug}', [HomeController::class, 'postView'])->name('berita.view');
// Route::get('/{slug}', [HomeController::class, 'postView'])->name('berita.view');

Route::get('video', [HomeController::class, 'videos'])->name('videos');

Route::get('tim-pengelola', function(){
    return view('tim-pengelola');
});

Route::get('/dashboard', function () {
    return redirect()->to('admin/dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';

Route::group(['middleware' => ['is_admin']], function(){
    Route::get('admin/dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');

    Route::get('admin/users', [UserController::class, 'index'])->name('admin.users');
    Route::get('admin/users/profile', [UserController::class, 'profile'])->name('admin.users.profile');
    Route::post('admin/users/list-data', [UserController::class, 'listData'])->name('admin.users.list.data');
    Route::get('admin/users/edit/{id}', [UserController::class, 'edit']);
    Route::post('admin/users/update', [UserController::class, 'update'])->name('admin.users.update');
    Route::post('admin/users/confirm/{id}', [UserController::class, 'confirm']);
    Route::post('admin/users/lock/{id}', [UserController::class, 'lock']);
    Route::post('admin/users/unlock/{id}', [UserController::class, 'unlock']);
    Route::post('admin/users/change-password', [UserController::class, 'changePassword'])->name('admin.users.change.password');
    Route::post('admin/profile/update', [UserController::class, 'updateProfile'])->name('admin.profile.update');


    Route::get('admin/perangkat-daerah', [OpdController::class, 'index'])->name('admin.opd');
    Route::post('admin/perangkat-daerah/store', [OpdController::class, 'store'])->name('admin.opd.store');
    Route::post('admin/perangkat-daerah/{id}', [OpdController::class, 'update'])->name('admin.opd.update');
    Route::delete('admin/perangkat-daerah/{id}', [OpdController::class, 'destroy'])->name('admin.opd.destroy');
    Route::get('admin/perangkat-daerah/load-data/{id}', [OpdController::class, 'getItem'])->name('admin.opd.item');
    Route::post('admin/opd/list-data', [OpdController::class, 'listData'])->name('admin.opd.list.data');


    Route::get('admin/kategori', [CategoryController::class, 'index'])->name('admin.category');
    Route::post('admin/kategori/store', [CategoryController::class, 'store'])->name('admin.category.store');
    Route::post('admin/kategori/{id}', [CategoryController::class, 'update'])->name('admin.category.update');
    Route::delete('admin/kategori/{id}', [CategoryController::class, 'destroy'])->name('admin.category.destroy');
    Route::get('admin/kategori/list-data', [CategoryController::class, 'listData'])->name('admin.category.listdata');
    Route::get('admin/kategori/load-data/{id}', [CategoryController::class, 'getItem'])->name('admin.category.item');

    Route::get('admin/media', [MediaController::class, 'index'])->name('admin.media');
    Route::get('admin/media/khusus', [MediaController::class, 'khusus'])->name('admin.media.khusus');
    Route::get('admin/media/create', [MediaController::class, 'create'])->name('admin.media.create');
    Route::get('admin/media/edit/{id}', [MediaController::class, 'edit'])->name('admin.media.edit');
    Route::get('admin/media/list-data', [MediaController::class, 'listData'])->name('admin.media.listdata');
    Route::get('admin/media/list-data-khusus', [MediaController::class, 'listDataKhusus'])->name('admin.media.listdatakhusus');
    Route::post('admin/media/store', [MediaController::class, 'store'])->name('admin.media.store');
    Route::post('admin/media/update', [MediaController::class, 'update'])->name('admin.media.update');
    Route::delete('admin/media/delete/{id}', [MediaController::class, 'destroy'])->name('admin.media.destroy');

    Route::get('admin/berita', [PostController::class, 'index'])->name('admin.berita');
    Route::get('admin/berita/create', [PostController::class, 'create'])->name('admin.berita.create');
    Route::get('admin/berita/edit/{id}', [PostController::class, 'edit'])->name('admin.berita.edit');
    Route::post('admin/berita/store', [PostController::class, 'store'])->name('admin.berita.store');
    Route::post('admin/berita/update', [PostController::class, 'update'])->name('admin.berita.update');
    Route::get('admin/berita/listdata', [PostController::class, 'listData'])->name('admin.berita.listdata');
    Route::post('admin/berita/delete/{id}', [PostController::class, 'destroy'])->name('admin.berita.destroy');
    
    Route::get('admin/videos', [VideoController::class, 'index'])->name('admin.videos');
    Route::get('admin/videos/listdata', [VideoController::class, 'listData'])->name('admin.videos.listdata');
    Route::post('admin/videos/store', [VideoController::class, 'store'])->name('admin.videos.store');
    Route::post('admin/videos/{id}', [VideoController::class, 'update'])->name('admin.videos.update');
    Route::delete('admin/videos/{id}', [VideoController::class, 'destroy'])->name('admin.videos.destroy');
    Route::get('admin/videos/load-data/{id}', [VideoController::class, 'getItem'])->name('admin.videos.item');
});
