@extends('layout')
@section('content')
<div class="content">
    <div class="container">
        <div class="card">
            <div class="card-body">
                <h3>SK TIM PENGELOLA</h3>
                <div style="padding: 10px; background: #fafafa; border: 1px solid black;">
                    <!--<object src="{{url('uploads/dummies.pdf')}}#toolbar=0" style="width: 100%; height: 600px;" type="application/pdf">-->
                    <!--<div id="pdf">-->
                    <!--    <object width="100%" height="650" type="application/pdf" data="{{url('uploads/dummies.pdf')}}#zoom=85&scrollbar=0&toolbar=0&navpanes=0" id="pdf_content" style="pointer-events: none;">-->
                    <!--        <p>Insert your error message here, if the PDF cannot be displayed.</p>-->
                    <!--    </object>-->
                    <!--</div>-->
                    
                    <!--<iframe -->
                    <!--    src="http://docs.google.com/viewer?url={{ url('uploads/dummies.pdf') }}&embedded=true" style="width:100%; height:500px;" frameborder="1">-->
                    <!--</iframe>-->
                    <canvas id="cnv"></canvas>
                    <br>
                    <button class="btn btn-default" id="prev">Prev</button>
                    <button class="btn btn-default" id="next">Next</button>
                    <br>
                    <span id="npages">not yet</span>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script>
    var url = '{{url('uploads/dummies.pdf')}}';

    

const PDFStart = nameRoute => {           
    let loadingTask = pdfjsLib.getDocument(nameRoute),
        pdfDoc = null,
        canvas = document.querySelector('#cnv'),
        ctx = canvas.getContext('2d'),
        scale = 1.5,
        numPage = 1;

        const GeneratePDF = numPage => {

            pdfDoc.getPage(numPage).then(page => {

                let viewport = page.getViewport({ scale: scale });
                    canvas.height = viewport.height;
                    canvas.width = viewport.width;
                
                let renderContext = {
                    canvasContext : ctx,
                    viewport:  viewport
                }

                page.render(renderContext);
            })
            document.querySelector('#npages').innerHTML = numPage;

        }

        const PrevPage = () => {
            if(numPage === 1){
                return
            }
            numPage--;
            GeneratePDF(numPage);
        }

        const NextPage = () => {
            if(numPage >= pdfDoc.numPages){
                return
            }
            numPage++;
            GeneratePDF(numPage);
        }

        document.querySelector('#prev').addEventListener('click', PrevPage)
        document.querySelector('#next').addEventListener('click', NextPage )

        loadingTask.promise.then(pdfDoc_ => {
            pdfDoc = pdfDoc_;
            document.querySelector('#npages').innerHTML = pdfDoc.numPages;
            GeneratePDF(numPage)
        });
}

const startPdf = () => {
    PDFStart('{{url('uploads/123.pdf')}}')
}

window.addEventListener('load', startPdf);
</script>
@endsection