@extends('layout')
@section('content')
<div class="content">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2>Berita</h2>
        <br>
        <div class="row">
          @foreach($recentsPosts as $post)
          @php 
            $writer = \App\Models\User::find($post->user_id);
          @endphp
          <div class="col-lg-3 col-md-6">
            <div class="card overflow-hidden">
              <div class="card-img-top" style="height: 200px; background-image: url('{{url("uploads/foto-berita/$post->image")}}'); background-size: cover; background-position: center"></div>
              <div class="card-body pt-2">
                <div class="d-flex flex-row justify-content-between text-sm text-muted mb-2">
                  <div>
                    <i class="fas fa-user mr-2"></i>
                    <span>{{ $writer->name }}</span>
                  </div>
                  <div>
                    <i class="fas fa-clock mr-2"></i>
                    <span>{{ formatDate($post->post_date, '%d/%m') }}</span>
                  </div>
                </div>
                <p class="card-text"><a href="{{url('berita/view/'.$post->slug)}}">{{ $post->title }}</a></p>
              </div>
            </div>
          </div>
          @endforeach
        </div>
        <br>
        <h2>Videos</h2>
        <br>
        <div class="row">
          @foreach($recentsVideos as $video) 
          <div class="col-lg-3 col-md-6">
            <div class="card overflow-hidden">
              <div class="card-img-top">
                  <iframe width="100%" src="{{ $video['link'] }}" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
              </div>
              <div class="card-body pt-2">
                <a href='{{$video['link']}}'>{{ $video['title'] }}</a>
              </div>
            </div>
          </div>
          @endforeach
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
@section('scripts')
@endsection