@extends('layout')
@section('content')
@php 
  $writer = \App\Models\User::find($post->user_id);
  $content = decodeContent($post->content);
@endphp
<div class="content">
  <div class="container pb-5">
      <div class="row">
            <div class="col-lg-8">
                <div class="card shadow-none">
                    <div class="card-body">
                        <img class="img-fluid" src="{{url('uploads/foto-berita/'.$post->image)}}">
                        <h2>{{ $post->title }}</h2>
                        
                        <div class="d-flex flex-row text-sm text-muted mb-2">
                            <div class="mr-2">
                                <i class="fas fa-user mr-1"></i>
                                <span>{{ $writer->name }}</span>
                            </div>
                            <div>
                                <i class="fas fa-clock mr-1"></i>
                                <span>{{ formatDate($post->post_date, '%d/%m %H:%m') }}</span>
                            </div>
                        </div>
                        
                        <div id="post-content" style="font-family: sans-serif, arial">
                            @php
                                echo $content;
                            @endphp
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 px-lg-4">
                <div class="sticky-top" style="top: 80px; z-index: 1">
                    <h4>Berita Terbaru</h4>
                    @foreach($recentPosts as $rp)
                    <div class="clearfix mb-3">
                        <div class="float-left mr-2 mt-1" style="width: 100px; height: 80px; background-image: url({{url('uploads/foto-berita/'.$rp->image)}}); background-size: cover; background-position: center;"></div>
                        <div class="">
                            <a class='link' href="{{url('berita/view/'.$rp->slug)}}">{{ substr($rp->title, 0, 80) }}...</a>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
      </div>
  </div>
</div>
@endsection
@section('script')
@endsection