
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>SIMANTU | Login</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="{{ URL::asset('plugins/fontawesome-free/css/all.min.css') }}">
  <link rel="stylesheet" href="{{ URL::asset('plugins/tabler-icons/webfont/tabler-icons.css') }}">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="{{ URL::asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css') }}">
  <!-- Theme style -->
  <link rel="stylesheet" href="{{ URL::asset('dist/css/adminlte.min.css') }}">
  <script async src="https://www.google.com/recaptcha/api.js"></script>
</head>
<body style="background-image: url({{url('img/login-bg.jpg')}}); background-attachment: fixed; background-position: center; backdrop-filter:blur(5px);">

  <div style="background: rgba(255,255,255,0.1); position: absolute; height:100vh; width: 100vw; backdrop-filter: blur(5px)" class="d-flex flex-row justify-content-center align-items-center">
    <div class="container">
      <div class="row">
        <div class="col-lg-8 offset-lg-2">
          <div class="card overflow-hidden">
            <div class="card-body p-0">
              <div class="row">
                <div class="col-lg-6" style="background: #16325B">
                  <div class="p-3 d-lg-flex flex-column justify-content-center align-items-center h-100 d-none" style="">
                    <div class="text-center text-white-50">
                      <img src="{{url("img/logo-ntt.png")}}" alt="" style="width: 125px; height: 125px;">
                      <h2 class=" text-bold text-white my-3">SIMANTU <small class=" text-white-50">v1.0</small></h2>
                      <p class="text-white-50">Sistem Informasi Manajemen Pengetahuan Pemerintah Provinsi Nusa Tenggara Timur</p>
                    </div>
                  </div>
                  <div class="d-lg-none text-center text-white-50 p-3">
                    <img src="{{url("img/ntt.png")}}" alt="" style="width: 75px; height: 75px; margin-top: 100px">
                    <h2 class=" text-bold text-white my-3">SIMANTU <small class=" text-white-50">v1.0</small></h2>
                    <p class="text-white-50">Sistem Informasi Manajemen Pengetahuan Pemerintah Provinsi Nusa Tenggara Timur</p>
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="p-lg-4 p-3">
                    
                    <p class="login-box-msg">Sign in to start your session</p>
                    
                    <form action="{{ route('login') }}" method="post">
                      @csrf
                      <div class="mb-3">
                          <div class="input-group">
                              <input type="email" name="email" class="form-control" placeholder="Email">
                              <div class="input-group-append">
                                  <div class="input-group-text">
                                  <span class="ti ti-mail-filled"></span>
                                  </div>
                              </div>
                          </div>
                          @if($errors->get('email'))
                          <span class='text-danger help-block'>{{ $errors->get('email')[0] }}</span>
                          @endif
                      </div>
                      <div class="mb-3">
                          <div class="input-group">
                              <input type="password" name="password" class="form-control" placeholder="Password">
                              <div class="input-group-append">
                                  <div class="input-group-text">
                                  <span class="ti ti-lock-filled"></span>
                                  </div>
                              </div>
                          </div>
                          @if($errors->get('password'))
                          <span class='text-danger help-block'>{{ $errors->get('password')[0] }}</span>
                          @endif
                      </div>
                      <!-- Google Recaptcha Widget-->
                      <div class="g-recaptcha my-3" data-sitekey={{env('RECAPTCHA_SITE_KEY')}}></div>
                      @if (Session::has('status'))
                        <div class="alert alert-info">{{ Session::get('status') }}</div>
                        @endif
                      <button type="submit" class="btn btn-primary btn-block">Masuk</button>
                    </form>
                    <br>
                    <p class="mb-1">Belum Punya akun?</p>
                    <p class="mb-0">
                    <a href="{{ route('daftar') }}" class="text-center">Daftar disini.</a>
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

<!-- jQuery -->
<script src="{{ URL::asset('plugins/jquery/jquery.min.js') }}"></script>
<!-- Bootstrap 4 -->
<script src="{{ URL::asset('plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
<!-- AdminLTE App -->
<script src="{{ URL::asset('dist/js/adminlte.min.js') }}"></script>
@include('sweetalert::alert')
</body>
</html>
