<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>
      <?php 
      $title = "SIMANTU | Sistem Informasi Manajemen Pengetahuan";
      if(isset($page_title)) $title = $page_title;
      echo $title;
      ?>
  </title>
  
  <?php 
  if(isset($meta)){
      foreach($meta as $meta){
          ?>
          <meta {{$meta[0]}}="{{$meta[1]}}" content="{{$meta[2]}}">
          <?php
      }
  }
  ?>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome Icons -->
  <link rel="stylesheet" href="{{ URL::asset('plugins/fontawesome-free/css/all.min.css') }}">
  <link rel="stylesheet" href="{{ URL::asset('plugins/bootstrap-icons/bootstrap-icons.css') }}">
  <link rel="stylesheet" href="{{ URL::asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ URL::asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ URL::asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
  <!-- Select2 -->
    <link rel="stylesheet" href="{{ URL::asset('plugins/select2/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ URL::asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
  <!-- Theme style -->
  <link rel="stylesheet" href="{{ URL::asset('dist/css/adminlte.min.css') }}">
  <link rel="stylesheet" href="{{ URL::asset('dist/css/stars.css') }}">
 <!--<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/4.6.82/pdf_viewer.min.css" integrity="sha512-682NKs3jUDtUlMV5W0Lnw0JoP0VvlS+6ruz0GEFzLZX9OyXw/StyvVV7sEM7Jf96OjoQqWUly3Sm7XvemWfTIA==" crossorigin="anonymous" referrerpolicy="no-referrer" />-->
  <style>
    body {
        background: #fafafa;
    }
    #navbar-top .container {
        display: flex;
        flex-direction: row;
    }
  
    .dt-footer {
        background: #fff;
        border-top: 1px solid #ddd;
    }
  	.dataTables_info {
  	    padding-top: 0px !important;
  	}
  	
  	.dataTables_length label {
  	    margin-bottom: 0px;
  	}
  	
  	.content-wrapper {
  	    background-color: #fafafa;
  	}
  	
  	.post-content {
  	    /*position: relative;*/
  	    
  	}
  	
  	.post-content::before {
  	    /*content: " ";*/
  	    /*position: absolute;*/
  	    /*top: 0;*/
  	    /*left: 0;*/
  	    /*display: block;*/
  	    /*width: 100%;*/
       /* height: 100%;*/
       /* background-image: url('{{URL::asset("img/techno.jpg")}}'); */
       /* background-attachment: fixed; */
       /* background-size: cover; */
       /* background-position: center; */
        /*filter: blur(5px); -webkit-filter: blur(5px);*/
  	}
  	
  	.post-card {
  	    background: transparent;
  	}
  	
  	.post-card .image {
  	    position: relative;
  	    overflow: hidden;
  	}
  	
  	.post-card .image::after {
  	    content: "";
        position: absolute;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        background: inherit;
        background-size: cover;
        transform-origin: center;
        transition: transform .4s ease-in-out;
  	}
  	
  	.post-card:hover .image::after {
  	    transform: scale(1.2);
  	}
  	
  	.post-card .card-body {
  	    position: relative;
  	    background: white;
  	}
  	
  	.post-card .card-body .info {
  	    position: absolute;
  	    width: 100%;
  	    top: -40px;
  	    left: 0;
  	    padding: 10px;
  	    background: rgba(0,0,0,.80);
  	    color: white;
  	}
  	
  	.post-card .card-body .info div {
  	    color: white;
  	}
  	
  	.post-card .card-body .title a {
  	    color: #444;
  	}
  	
  	.post-card .card-body .title a:hover {
  	    color: #08c;
  	}
  	
  	#navbar {
  	    background: rgba(255,255,255,.80); 
  	    backdrop-filter: blur(5px);
  	}
  	
  	.content-wrapper {
  	    margin-top: 20px;
  	}
  	
  	.link {
  	    color: #444;
  	}
  	
  	.link:hover {
  	    color: #08c;
  	}
  	
  	#post-content img {
  	    max-width: 740px !important;
  	}
  	
  	footer {
  	    background: #fafafa !important; 
  	    border-top: 1px solid rgba(0,0,0,.80);
  	    padding: 0px !important;
  	    color: #888888 !important;
  	}
  	
  	#navbar div ul li .nav-link {
  	    color: #444 !important;
  	}
  	
  	#navbar div ul li .nav-link:hover {
  	    color: blue !important;
  	}
  	
  </style>
</head>
<body class="hold-transition layout-top-nav">
<div class="wrapper">
    
    <!--<div id="top-nav">-->
        <div class="py-3" style="background: white;">
            <div class="container">
                <div class="d-flex flex-row justify-content-lg-between align-items-center">
                    <a class="navbar-brand" href="#">
                        <img src="{{ URL::asset('img/simantu.png') }}" style="width: 250px;">
                    </a>
                    
                    <div>
                        @if(!Auth::check())
                            <div class="my-2 my-lg-0">
                                <a href="{{ url('login') }}" class="nav-link btn btn-success" role="button" style="border-radius: 20px">
                					<i class="bi bi-person-circle mr-2"></i>
                					Login
                				</a>
                            </div>
                        @else
                            <div class="my-2 my-lg-0">
                                <a href="{{ route('admin.dashboard') }}" class="nav-link btn btn-primary" role="button">
                			        <i class="fas fa-user-circle mr-2"></i>
                			        {{ Auth::user()->name }}
                			    </a>
                            </div>
                        @endif  
                    </div>
                </div>
            </div>
        </div>
        <nav id="navbar" class="navbar navbar-expand-lg navbar-light sticky-top" style="top: -2px; border-bottom: 1px solid #ddd;">
          <div class="container">
            
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav mr-auto">
                    <li class="nav-item">
                        <a href="{{url('')}}" class="nav-link">Home</a>
                    </li>
                    <li class="nav-item">
                        <a href="{{route('berita')}}" class="nav-link">Berita</a>
                    </li>
                    <li class="nav-item">
                        <a href="{{route('videos')}}" class="nav-link">Video</a>
                    </li>
                    <li class="nav-item">
                        <a href="{{url('tim-pengelola')}}" class="nav-link">Tim Pengelola</a>
                    </li>
                </ul>
                <div class="d-flex flex-row justify-content-end align-items-center">
                    <a href="" class="mx-2"><i class="fab fa-facebook"></i></a>
                    <a href="" class="mx-2 text-purple"><i class="fab fa-instagram"></i></a>
                    <a href="" class="mx-2 text-danger"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
          </div>
      </nav>
    <!--</div>-->


  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper" style="background: #fafafa">

  	<br> 

		<!-- Main content -->
    @yield('content')
		<!-- /.content -->
  </div>
  <!-- /.content-wrapper -->


  <!-- Main Footer -->
  <footer class="main-footer" style="border: 1px 0 0 0 solid rgba(0,0,0,.08)">
    <div class="container pt-3">
        <div class="row mb-3">
            <div class="col-lg-4">
                <img src="{{ URL::asset('img/simantu.png') }}" style="width: 300px;">
                <div class="py-3">
                    Jl. Palapa, Oebobo, Kec. Oebobo, Kota Kupang, Nusa Tenggara Tim.
                </div>
                <div class="py-3">
                    <span class="d-block">
                        <i class="fa fa-phone fa-fw"></i>
                        Telepon: 0823-4015-5244
                    </span>
                    <span class="d-block">
                        <i class="fa fa-envelope fa-fw"></i>
                        Email: simantu.nttprov@go.id
                    </span>
                </div>
            </div>
            <div class="col-lg-4 px-lg-3 text-lg-right ml-lg-auto">
                
            </div>
        </div>
        
    </div>
    <div class="py-3" style="background: white;">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <strong>Copyright &copy; 2020 - {{ date('Y') }} &nbsp;&nbsp; <a href="https://adminlte.io">SPBE NTT</a>.</strong>
                </div>
                <div class="col-lg-6 text-lg-right">
                    V0.0.1
                </div> 
            </div>
        </div>
    </div>
  </footer>
</div>
<!-- ./wrapper -->

<!-- REQUIRED SCRIPTS -->

<!-- jQuery -->
<script src="{{ URL::asset('plugins/jquery/jquery.min.js') }}"></script>
<!-- Bootstrap 4 -->
<script src="{{ URL::asset('plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
<script src="{{ URL::asset('plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ URL::asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ URL::asset('plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ URL::asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
<!-- Select2 -->
  <script src="{{ URL::asset('plugins/select2/js/select2.full.min.js') }}"></script>
<!-- AdminLTE App -->
<script src="{{ URL::asset('dist/js/adminlte.min.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.js" integrity="sha512-dfMpvQclalfL7nRtHdy4+U2GLYb2XJJOgGLgKibrbcbarI/ZLgCAaBCS6+AuWN0OtLn/zFpu+Cggd8TCBYx9Ag==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.worker.js" integrity="sha512-Y2115aLowncqghxp0ca1wqpkPu5GBtpZg1S/oRdSczGJc99r1GrY2CserqV5QrfQvE575qFlHKC6vnMD2i6fsQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
@yield('script')
<script>
</script>
</body>
</html>
