@extends('admin.layout.app')
@section('content')
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>Profile</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class=" breadcrumb-item"><a href="#">Home</a></li>
          <li class=" breadcrumb-item active">Profile</li>
        </ol>
      </div>
    </div>
  </div>
</div>
<div class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-6">
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">Data Pribadi</h3>
          </div>
          <div class="card-body">
            <form action="{{route('admin.profile.update')}}" method="post">
              @csrf

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Nama Lengkap</label>
                <div class="col-lg-8">
                  <input type="text" name="name" class="form-control" value="{{$user->name}}">
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Jenis Kelamin</label>
                <div class="col-lg-8">
                  <div class="custom-control custom-radio custom-control-inline">
                    <input type="radio" id="radio1" name="sex" class="custom-control-input" value="male" {{ $user->sex == "male" ? "checked" : "" }}>
                    <label class="custom-control-label" for="radio1">Laki-laki</label>
                  </div>
                  <div class="custom-control custom-radio custom-control-inline">
                    <input type="radio" id="radio2" name="sex" class="custom-control-input" value="female" {{ $user->sex == "female" ? "checked" : "" }}>
                    <label class="custom-control-label" for="radio2">Perempuan</label>
                  </div>
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Unit Kerja</label>
                <div class="col-lg-8">
                  <select name="opd_id" class="form-control">
                  <option value="">Pilih Unit Kerja</option>
                  @foreach($opd as $item)
                  <option value="{{ $item->id }}" {{ $user->opd_id == $item->id ? "selected" : "" }}>{{ $item->name }}</option>
                  @endforeach 
                  </select>
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Pangkat/Golongan</label>
                <div class="col-lg-8">
                  <input type="text" name="grade_class" class="form-control" value="{{$user->grade_class}}">
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Jabatan</label>
                <div class="col-lg-8">
                  <input type="text" name="position" class="form-control" value="{{$user->position}}">
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">NIP</label>
                <div class="col-lg-8">
                  <input type="text" name="nip" class="form-control" value="{{$user->nip}}">
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Telepon</label>
                <div class="col-lg-8">
                  <input type="text" name="phone" class="form-control" value="{{$user->phone}}">
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Email</label>
                <div class="col-lg-8">
                  <input type="text" name="email" class="form-control" value="{{$user->email}}">
                </div>
              </div>

              <div class="row">
                <div class="col-lg-8 offset-lg-4 text-right">
                  <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
              </div>


            </form>
          </div>
        </div>
      </div>
      {{-- end col --}}
      <div class="col-lg-6">
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">Ubah Password</h3>
          </div>
          <div class="card-body">
            <form action="{{route('admin.users.change.password')}}" method="post">
              @csrf

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Password Lama</label>
                <div class="col-lg-8" data-password-field>
                  <input type="password" name="old_pass" class="form-control" required value="{{old('old_pass') ?? ''}}">
                  <div class="password-btn" data-password-field-btn><span>Show</span><span>Hide</span></div>
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Password Baru</label>
                <div class="col-lg-8" data-password-field>
                  <input type="password" name="new_pass" class="form-control" required value="{{old('new_pass') ?? ''}}">
                  <div class="password-btn" data-password-field-btn><span>Show</span><span>Hide</span></div>
                </div>
              </div>

              <div class="form-group row">
                <label class="col-form-label col-lg-4">Konfirmasi Password </label>
                <div class="col-lg-8" data-password-field>
                  <input type="password" name="confirm_pass" class="form-control" required value="{{old('confirm_pass') ?? ''}}">
                  <div class="password-btn" data-password-field-btn><span>Show</span><span>Hide</span></div>
                </div>
              </div>

              <div class="row">
                <div class="col-lg-8 offset-lg-4 text-right">
                  <button type="submit" class="btn btn-primary">Ubah Password</button>
                </div>
              </div>
              
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
@section('script')
<script>
  new inputShowPwd('new_pass');
</script>
@endsection