@extends('admin.layout.app')

@section('content')
	<div class="content-header">
		<div class="container-fluid">
			<div class="row mb-2">
				<div class="col-sm-6">
					<h1>Data User</h1>
				</div>
				<div class="col-sm-6">
					<ol class="breadcrumb float-sm-right">
						<li class=" breadcrumb-item"><a href="#">Home</a></li>
						<li class=" breadcrumb-item active">Users</li>
					</ol>
				</div>
			</div>
		</div>
	</div>
	<div class="content">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card">
						<div class="card-header">
							<h3 class="card-title">Data User</h3>
						</div>
						<div class="card-body">
							<table id="table-user" class="table table-hover" style="width: 100%">
								<thead>
									<th>No</th>
									<th class="all">Nama</th>
									{{-- <th class="none">Jenis Kelamin</th> --}}
									<th>Unit Kerja</th>
									<th>Pangkat/Golongan</th>
									<th>Email</th>
									<th>Level</th>
									<th>Status</th>
									<th></th>
								</thead>
								<tbody>

								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection

@section('script')
	<script>
		var table = $('#table-user').DataTable({
			processing: true,
			serverSide: true,
// 			responsive: true,
			order: [1, 'asc'],
			ajax: {
				url: "{{ route('admin.users.list.data') }}",
				type: "POST",
				headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')}
			},
			columns: [
				{data: null, width: 50, orderable: false, render: function(data, type, row, meta){
					return meta.row + meta.settings._iDisplayStart + 1;
				}},
				{data: 'name'},
				// {data: null, render: function(data, type, row, meta){
				//     return data.sex == 'male' ? 'Pria' : 'Wanita';
				// }},
				{data: 'unit_name'},
				{data: 'grade_class'},
				{data: 'email'},
				{data: null, render: function(data, row){
					return ucwords(data.level);
				}},
				{data: null, class: '', render: function(data, type, row, meta){
					if(data.status == 'active')
						return '<span class="badge badge-success"><i class="fas fa-check"></i></span>';
					else if(data.status == 'not active')
						return '<span class="badge badge-danger">Not Active</span>';
					else if(data.status == 'locked')
						return '<span class="badge badge-warning"><i class="fas fa-lock"></i></span>';
				}},
				{data: null, orderable: false, render: function(data, type, row, meta){
					var menu = `<div class="dropdown">
							<a href="#" data-toggle="dropdown" class="text-secondary text-sm">
								<i class="fas fa-cog"></i>
							</a>
							<div class="dropdown-menu dropdown-menu-right text-sm">`;
					if(data.status == 'active' && data.level != 'admin')
						menu += `<a href="#" onclick="event.preventDefault(); lockUser(${data.id})" class="dropdown-item"><i class="fas fa-lock-alt fa-fw mr-1"></i> Kunci Akun</a>`;
					else if(data.status == 'not active')
						menu += `<a href="#" onclick="event.preventDefault(); confirmUser(${data.id})" class="dropdown-item"><i class="fas fa-user-check fa-fw mr-1"></i> Konfirmasi Akun</a>`;
					else if(data.status == 'locked')
						menu += `<a href="#" onclick="event.preventDefault(); unlockUser(${data.id})" class="dropdown-item"><i class="fas fa-lock-open fa-fw mr-1"></i> Unlock Akun</a>`;
					if(data.level != 'admin')
						menu += `<a href="{{ url('admin/users/edit') }}/${data.id}" class="dropdown-item"><i class="fas fa-edit fa-fw mr-1"></i> Edit Akun</a>`;
					menu += `<a href="#" class="dropdown-item detail"><i class="fas fa-search fa-fw mr-1"></i> Lihat Detail</a>`;
					menu += `</div></div>`;
					
					return menu;
				}}
			]
		});

		table.on('click', 'a.detail', function(e){
			let data = table.row(e.target.closest('tr')).data();
			showDetail(data);
		});

		function confirmUser(UserId){
			var url_delete = `{{ url('admin/users/confirm') }}/${UserId}`;
			Swal.fire({
				icon: 'question',
				title: 'Konfirmasi User',
				text: 'Anda yakin ingin mengkonfirmasi akun ini?',
				showCancelButton: true,
				reverseButtons: true,
				showLoaderOnConfirm: true,
				preConfirm: async() => {
					try {
						const response = await fetch(url_delete, {
							method: 'POST',
							headers: {
								'Content-Type': 'application/json',
								'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
							}
						});

						if(!response.ok){
							return Swal.showValidationMessage(`${JSON.stringify(await response.json())}`)
						}

						return response.json();

					}catch(error){
						Swal.showValidationMessage(`Request failed: ${error}`);
					}
				},
				allowOutsideClick: () => !Swal.isLoading()
			}).then(result => {
				if(result.isConfirmed){
					if(result.value.status || result.value.success){
						Swal.fire({'icon': 'success', 'title': result.value.message});
						table.ajax.reload();
					}else{
						Swal.fire({'icon': 'error', 'title': result.value.message});
					}
				}
			})
		}

		function lockUser(UserId){
			var url_lock = `{{ url('admin/users/lock') }}/${UserId}`;
			confirm('Kunci User', 'Anda yakin ingin mengunci akun user ini?', url_lock, function(){
				table.ajax.reload();
			})
		}

		function unlockUser(UserId){
			var url_unlock = `{{url('admin/users/unlock')}}/${UserId}`;
			confirm('Aktifkan User', 'Anda yakin ingin mengaktifkan akun user ini?', url_unlock, function(){
				table.ajax.reload();
			});
		}
	</script>
@endsection