@extends('admin.layout.app')

@section('content')
<div class="content-header">
	<div class="container-fluid">
		<div class="row mb-2">
			<div class="col-sm-6">
				<h1>Edit User</h1>
			</div>
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
					<li class=" breadcrumb-item"><a href="#">Home</a></li>
					<li class=" breadcrumb-item"><a href="{{ route('admin.users') }}">Users</a></li>
					<li class=" breadcrumb-item active">Edit User</li>
				</ol>
			</div>
		</div>
	</div>
</div>
<div class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h3 class="card-title">Edit User</h3>
					</div>
					<form action="{{ route('admin.users.update') }}" method="POST">
						@csrf
						<div class="card-body">

							<div class="form-group row">
								<label class="col-form-label col-lg-2">Nama Lengkap</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="name" required="required" value="{{ $user->name }}">
								</div>
							</div>
							
							<div class="form-group row">
								<label class="col-form-label col-lg-2">Jenis Kelamin</label>
								<div class="col-lg-2">
									<select name="sex" class="form-control" required>
										@foreach(['male' => 'Laki-laki', 'female' => 'Perempuan'] as $key => $value)
										<option value="{{ $key }}" {{ $key == $user->sex ? 'selected' : '' }}>{{ $value }}</option>
                    @endforeach
									</select>
								</div>
							</div>

							<div class="form-group row">
								<label class="col-form-label col-lg-2">Unit Kerja</label>
								<div class="col-lg-10">
									<select name="opd_id" class="form-control" required>
										@foreach($opd as $item)
											<option value="{{ $item->id }}" {{ $item->id == $user->opd_id ? 'selected' : '' }}>{{ $item->name }}</option>
											@endforeach
									</select>
								</div>
							</div>

							<div class="form-group row">
								<label class="col-form-label col-lg-2">Pangkat / Golongan</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="grade_class" required="required" value="{{ $user->grade_class }}">
								</div>
							</div>

							<div class="form-group row">
								<label class="col-form-label col-lg-2">Jabatan</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="position" required="required" value="{{ $user->position }}">
								</div>
							</div>

							<div class="form-group row">
								<label class="col-form-label col-lg-2">NIP</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="nip" required="required" value="{{ $user->nip }}">
								</div>
							</div>

							<div class="form-group row">
								<label class="col-form-label col-lg-2">Email</label>
								<div class="col-lg-10">
									<input type="email" class="form-control" name="email" required="required" value="{{ $user->email }}">
								</div>
							</div>

							<div class="form-group row">
								<label class="col-form-label col-lg-2">Telepon</label>
								<div class="col-lg-4">
									<input type="text" class="form-control" name="phone" required="required" value="{{ $user->phone }}">
								</div>
							</div>

							<div class="form-group row">
								<label class="col-form-label col-lg-2">Password</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="password" value="">
									<span class="text-muted text-sm">Tinggalkan kosong jika tidak diubah.</span>
								</div>
							</div>

						</div>
						<div class="card-footer d-flex">
							<input type="hidden" name="id" value="{{ $user->id }}">
							<a href="{{ route('admin.users') }}" class="btn btn-default">Batal</a>
							<button type="submit" class="btn btn-primary ml-auto">Simpan</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection

@section('script')
	
@endsection