@extends('admin.layout.app')
@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Perangkat Daerah</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class=" breadcrumb-item"><a href="#">Home</a></li>
                    <li class=" breadcrumb-item active">Perangkat Daerah</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Data User</h3>
                        <div class=" card-tools">
                          <button class="btn btn-tool" onclick="table.ajax.reload()"><i class="fas fa-sync-alt"></i></button>
                          <button class="btn btn-tool mr-2" data-card-widget="maximize">
                            <i class="fas fa-expand"></i>
                          </button>
                          <button class="btn btn-sm btn-primary" onclick="addOpd()"><i class="fas fa-plus-square mr-2"></i>Tambah</button>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="table-opd" class="table table-hover">
                            <thead>
                                <th>#</th>
                                <th>Nama</th>
                                <th>Alamat</th>
                                <th>Deskripsi</th>
                                <th></th>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="opd-modal">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Tambah Perangkat Daerah</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="">
                        <div class="modal-body">
                            <div class="form-group mb-3">
                                <label for="" class="">Nama PD</label>
                                <input type="text" class="form-control" id="name" name="name" required placeholder="Nama Perangkat Daerah">
                            </div>
                            <div class="form-group">
                                <label for="" class="">Alamat</label>
                                <input type="text" class="form-control" name="address" required placeholder="Alamat Perangkat Daerah">
                            </div>
                            <div class="form-group">
                                <label for="" class="">Deskripsi</label>
                                <textarea class="form-control" name="description"></textarea>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary"><span>Simpan</span></button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script>
    var table = $('#table-opd').DataTable({
        processing: true,
        serverSide: true,
        order: [1, 'asc'],
        ajax: {
            url: "{{ route('admin.opd.list.data') }}",
            type: "POST",
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')}
        },
        columns: [
            {data: null, width: '40px', orderable: false, render: function(data, type, row, meta){
                return meta.row + meta.settings._iDisplayStart + 1;
            }},
            {data: 'name'},
            {data: 'address'},
            {data: 'description'},
            {data: null, width: '50px', orderable: false, render: function(data, type, row){
                return `<div class='dropdown text-sm'>
                    <a href='#' data-toggle='dropdown' class='text-muted'>
                        <i class='fas fa-cog'></i>
                    </a>
                    <div class='dropdown-menu dropdown-menu-right'> 
                        @can('update opd')
                        <a href='#' class='dropdown-item' onclick='event.preventDefault(); editOpd(${data.id})'><i class='fas fa-edit mr-2'></i> Edit</a>
                        @endcan
                        @can('delete opd')
                        <a href='#' class='dropdown-item' onclick='event.preventDefault(); deleteOpd(${data.id})'><i class=' fas fa-trash-alt mr-2'></i> Hapus</a>
                        @endcan
                    </div> 
                </div>`;
            }}
        ]
    });

    var submitUrl = '';
    var modal = $('#opd-modal');
    var form = modal.find('form');
    var btnSubmit = form.find('[type=submit]');

    modal.on('hidden.bs.modal', function(){
        form.form('clear');
    });

    function addOpd(){
        modal.modal('show');
        submitUrl = '{{ route('admin.opd.store')}}';
    }

    function editOpd(opd_id){
        axios.get('{{ url('admin/perangkat-daerah/load-data') }}/'+opd_id)
        .then(function(response){
            form.form('load', response.data);
            modal.modal('show');

            submitUrl = '{{ url('admin/perangkat-daerah') }}/'+opd_id;
        });
    }

    function deleteOpd(opd_id){

        var url_delete = '{{ url('admin/perangkat-daerah/') }}/'+opd_id;
        Swal.fire({
            icon: 'question',
            title: 'Hapus Perangkat Daerah',
            text: 'Data tidak dapat dikembalikan setelah dihapus. Anda yakin ingin melanjutkan?',
            showCancelButton: true,
            cancelButtonText: '<i class="ri-close-line"></i> Batal',
            confirmButtonText: '<i class="ri-delete-bin-6-line"></i> Ya, Hapus',
            reverseButtons: true,
            buttonsStyling: false,
            customClass: {
                confirmButton: 'btn btn-danger ml-3',
                cancelButton: 'btn btn-default'
            },
            showLoaderOnConfirm: true,
            preConfirm: async() => {
                try {
                    const response = await fetch(url_delete, {
                        method: 'DELETE',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    if(!response.ok){
                        return Swal.showValidationMessage(`${JSON.stringify(await response.json())}`)
                    }

                    return response.json();

                }catch(error){
                    Swal.showValidationMessage(`Request failed: ${error}`);
                }
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then(result => {
            if(result.isConfirmed){
                if(result.value.status || result.value.success){
                    Swal.fire({'icon': 'success', 'title': result.value.message});
                    table.ajax.reload();
                }else{
                    Swal.fire({'icon': 'error', 'title': result.value.message});
                }
            }
        })
    }

    form.on('submit', function(e){
        e.preventDefault();
        var formdata = $(this).serialize();

        btnSubmit.indicator();

        axios
        .post(submitUrl, formdata)
        .then(function(response){
            if(!response.data.success){

            }else{
                Toast.fire({
                    icon: "success",
                    title: response.data.message
                });
                modal.modal('hide');
                table.ajax.reload();
            }
        })
        .catch(function(error){
            console.log(error);
        })
        .then(function(){
            btnSubmit.indicator('reset');
        })
    });
</script>
@endsection