@extends('admin.layout.app')

@section('content')
<div class="content-header">
	<div class="container-fluid">
		<div class="row mb-2">
			<div class="col-sm-6">
				<h1>Data Media</h1>
			</div>
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
					<li class=" breadcrumb-item"><a href="#">Home</a></li>
					<li class=" breadcrumb-item"><a href="{{ route('admin.media') }}">Media</a></li>
					<li class=" breadcrumb-item active">Tambah Media</li>
				</ol>
			</div>
		</div>
	</div>
</div>
<div class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h3 class="card-title">Tambah Media</h3>
					</div>
					<div class="card-body">
						<form action="{{ route('admin.media.store') }}" method="post" enctype="multipart/form-data">
							@csrf
							<div class="form-group row">
								<label for="title" class="col-form-label col-lg-2">Judul</label>
								<div class="col-lg-10">
									<input type="text" id="title" name="title" class="form-control" required="" placeholder="Judul Dokumen / Media" value="{{ old("title") ?? "" }}">
								</div>
							</div>
							<div class="form-group row">
								<label for="writer" class="col-form-label col-lg-2">
									Penulis
									<a href="#" data-toggle="tooltip" title="Penulis atau author adalah nama penulis, penyusun, atau pembuat pengetahuan SPBE"><i class="fas fa-info-circle"></i></a>
								</label>
								<div class="col-lg-10">
									<input type="text" id="writer" name="writer" class="form-control" required="" placeholder="" value="{{old("writer")}}">
								</div>
							</div>
							<div class="form-group row">
								<label for="writer" class="col-form-label col-lg-2">Instansi</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="opd_id" disabled value="{{ $opd->name }}">
								</div>
							</div>
							<div class="form-group row">
								<label for="description" class="col-form-label col-lg-2">Deskripsi</label>
								<div class="col-lg-10">
                  <div class="text-limiter">
									  <textarea name="description" id="description" class="form-control" data-maxchar="255" style="resize: none;" rows="5">{{old("description") ?? ""}}</textarea>
                    <div class="text-right text-sm text-muted">
                      <em>max. character allowed are</em>
                      <em class="character-counter"></em>
                    </div>
                  </div>
								</div>
							</div>
							<div class="form-group row">
								<label for="category" class="col-form-label col-lg-2">Lingkup SPBE</label>
								<div class="col-lg-10">
									<select name="category_id" id="category" class="form-control" required>
										@foreach($categories as $item)
										<option value="{{ $item->id }}" {{ old("category_id") && old("category_id") == $item->id ? "selected" : "" }}>{{ $item->name }}</option>
										@endforeach
									</select>
								</div>
							</div>
							<div class="form-group row">
								<label for="media" class="col-form-label col-lg-2">Media</label>
								<div class="col-lg-10">
								    <div style="padding: 15px; background: #fcfcfc; border: 1px solid #eeeeee; border-radius: 5px;">
								        <div class="alert alert-warning" role="alert">
                                            <i class="fas fa-exclamation-triangle"></i>
                                            Silahkan upload file anda atau masukkan link url penulisan anda.
                                        </div>
								        <div class="row">
								            <div class="col-lg-4">
								                <input type="file" id="media" name="media" class="form-control" placeholder="" data-allowed-file-extensions="pdf doc docx" data-errors-position="outside" accept=".pdf,.doc,.docx" data-height="150" data-max-file-size="5M">
								            </div>
								        </div>
                                        <div class="text-muted text-sm">
                                            <ul style="padding-left: 10px;">
                                              <li>Format file yang diperbolehkan: PDF, DOC, DOCX</li>
                                              <li>Ukuran maksimal file: 5MB</li>
                                            </ul>
                                        </div>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">Link URL</span>
                                            </div>
                                            <input type="text" class="form-control" name="link" placeholder="https://">
                                        </div>
                                    </div>
								</div>
                            </div>
							<div class="form-group row">
								<label for="contributor" class="col-form-label col-lg-2">
									Kontributor
									<a href="#" data-toggle="tooltip" title="Kontributor atau nama pendukung yang memberikan kontribusi pada penulis dalam menyusun pengetahuan SPBE. Kontributor bisa berjumlah lebih dari satu."><i class="fas fa-info-circle"></i></a>
								</label>
								<div class="col-lg-10">
									<textarea id="contributor" class="form-control" name="contributor" required="" placeholder="">{{ old("contributor") ?? "" }}</textarea>
								</div>
							</div>
							<div class="form-group row">
								<label for="tags" class="col-form-label col-lg-2">
									Kata Kunci
									<a href="#" data-toggle="tooltip" title="Kata kunci dari pengetahuan SPBE untuk memudahkan pencarian kembali."><i class="fas fa-info-circle"></i></a>
								</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="tags" id="tags" value="{{old("tags") ?? ""}}">
									<span class="text-sm text-muted">Pisahkan dengan tanda <strong>;</strong></span>
								</div>
							</div>
							<div class="form-group row">
								<label for="visibility" class="col-lg-2 col-form-label">Status Publikasi</label>
								<div class="col-lg-10">
									<select name="visibility" id="visibility" class="form-control">
										<option value="1" {{old("visibility") && old("visibility") == "1" ? "selected" : ""}}>Umum</option>
										<option value="0" {{old("visibility") && old("visibility") == "1" ? "selected" : ""}}>Terbatas</option>
									</select>
								</div>
							</div>
							<div class="form-group row">
								<label for="pubdate" class="col-form-label col-lg-2">Tanggal Publikasi</label>
								<div class="col-lg-10">
									<input type="text" id="pubdate" name="publication_date" class="form-control datepicker" required="" placeholder="" value="{{old("publication_ate") ?? ""}}">
								</div>
							</div>
							<div class="d-flex flex-row border-top py-3">
								<a href="{{ route('admin.media') }}" onclick="return confirm('Anda yakin ingin meninggalkan halaman ini?')" class="btn btn-default">Batal</a>
								<button type="submit" class="btn btn-primary ml-auto">Tambah</button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection

@section('script')
	<script>
		$('.datepicker').daterangepicker({
			singleDatePicker: true,
			showDropdowns: true,
			locale: {
				format: 'YYYY-MM-DD'
			}
		});

    $('#description').characterlimit();

    $('#media').dropify({
      'messages': {
      'default': 'Tarik atau klik disini untuk mengunggah file',
      'replace': 'Tarik atau klik disini untuk mengganti file',
      'remove':  'Hapus',
      'error':   'Ooops, terjadi kesalahan upload'
    }
    });
	</script>
@endsection