<!DOCTYPE html>
<!--
This is a starter template page. Use this page to start your new project from
scratch. This page gets rid of all links and provides the needed markup only.
-->
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
	<title>Simantu | {{ isset($page_title) ? $page_title : 'Dashboard' }}</title>

	<!-- Google Font: Source Sans Pro -->
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
	<!-- Font Awesome Icons -->
	<link rel="stylesheet" href="{{ URL::asset('plugins/fontawesome-free/css/all.min.css') }}">
	<link rel="stylesheet" href="{{ URL::asset('plugins/tabler-icons/webfont/tabler-icons.css') }}">
	<!-- Bootstrap Icons -->
	<link rel="stylesheet" href="{{ URL::asset('plugins/bootstrap-icons/bootstrap-icons.css') }}">
	<!-- SweetAlert2 -->
	<link rel="stylesheet" href="{{ URL::asset('plugins/sweetalert2/sweetalert2.min.css') }}">
    <!-- DataTables -->
    <link rel="stylesheet" href="{{ URL::asset('plugins/dttables/dataTables.bootstrap4.css') }}">
    <link rel="stylesheet" href="{{ URL::asset('plugins/dttables/responsive.bootstrap4.css') }}">
    <!-- Select2 -->
    <link rel="stylesheet" href="{{ URL::asset('plugins/select2/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ URL::asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
    {{-- Dropify --}}
    <link rel="stylesheet" href="{{ URL::asset('plugins/dropify/css/dropify.min.css') }}">
    <!-- ShowPwd -->
    <link rel="stylesheet" href="{{ URL::asset('plugins/show-pwd/jquery.password-field.css') }}">
	<!-- Summernote -->
	<link rel="stylesheet" href="{{ URL::asset('plugins/summernote/summernote-bs4.min.css') }}">
	<!-- Daterangepicker -->
	<link rel="stylesheet" href="{{ URL::asset('plugins/daterangepicker/daterangepicker.css') }}">
	<!-- Theme style -->
	<link rel="stylesheet" href="{{ URL::asset('dist/css/adminlte.min.css') }}">
	<style>
		.col-form-label {
			font-weight: normal !important;
		}

		#form-logout a:hover {
			color: white !important;
		}

		td.dtr-control::before {
      font-family: "Font Awesome 6 Pro";
			content: '\f105' !important;
			border: 0px !important;
      transform: rotate(0deg);
      transition: transform .25s linear;
		}

    tr.dtr-expanded td.dtr-control::before {
      transform: rotate(90deg);
      transition: transform .25s linear;
    }

    td.child {
      padding: 0;
      padding-left: 50px;
      background: #f5f5f5;
    }

    .ti {
      font-size: 15px;
    }

    .dropify-wrapper .dropify-message span.file-icon p {
      font-size: 16px !important;
    }
	</style>
</head>

<body class="hold-transition sidebar-mini layout-navbar-fixed layout-fixed">
	<div class="wrapper">

		<!-- Navbar -->
		<nav class="main-header navbar navbar-expand navbar-white navbar-light">
			@include('admin.components.topbar')
		</nav>
		<!-- /.navbar -->

		<!-- Main Sidebar Container -->
		<aside class="main-sidebar sidebar-dark-primary elevation-4">
			<!-- Brand Logo -->
			<a href="{{ url('') }}" class="brand-link">
				<img src="{{ URL::asset('dist/img/AdminLTELogo.png') }}" alt="AdminLTE Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
				<span class="brand-text font-weight-light">SIMANTU</span>
			</a>

			<!-- Sidebar -->
			<div class="sidebar">
				<!-- Sidebar user panel (optional) -->
				<div class="user-panel mt-3 pb-3 mb-3 d-flex">
					<div class="image">
						<img src="{{ URL::asset('img/user.png') }}" class="img-circle elevation-1" alt="User Image">
					</div>
					<div class="info">
						<a href="{{route('admin.users.profile')}}" class="d-block">{{ getUser()->name }}</a>
					</div>
				</div>

				<!-- SidebarSearch Form -->
				<div class="form-inline">
					<div class="input-group" data-widget="sidebar-search">
						<input class="form-control form-control-sidebar" type="search" placeholder="Search" aria-label="Search">
						<div class="input-group-append">
							<button class="btn btn-sidebar">
								<i class="fas fa-search fa-fw"></i>
							</button>
						</div>
					</div>
				</div>

				<!-- Sidebar Menu -->
				@include('admin.components.sidebar')
				<!-- /.sidebar-menu -->
			</div>
			<!-- /.sidebar -->
		</aside>

		<!-- Content Wrapper. Contains page content -->
		<div class="content-wrapper">
			@yield('content')
		</div>
		<!-- /.content-wrapper -->

		<!-- Control Sidebar -->
		<aside class="control-sidebar control-sidebar-dark">
			<!-- Control sidebar content goes here -->
			<div class="p-3">
				<h5>Title</h5>
				<p>Sidebar content</p>
			</div>
		</aside>
		<!-- /.control-sidebar -->

		<!-- Main Footer -->
		@include('admin.components.footer')
	</div>
	<!-- ./wrapper -->

	<!-- REQUIRED SCRIPTS -->

	<!-- jQuery -->
	<script src="{{ URL::asset('plugins/jquery/jquery.min.js') }}"></script>
	<script src="{{ URL::asset('plugins/jquery.parser.js') }}"></script>
	<script src="{{ URL::asset('plugins/jquery.form.js') }}"></script>
	<!-- Bootstrap 4 -->
	<script src="{{ URL::asset('plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
	<!-- SweetAlert2 -->
	<script src="{{ URL::asset('plugins/sweetalert2/sweetalert2.all.js') }}"></script>
	<!-- Axios -->
	<script src="{{ URL::asset('plugins/axios.min.js') }}"></script>
    <!-- DataTables  & Plugins -->
    <script src="{{ URL::asset('plugins/dttables/dataTables.js') }}"></script>
    <script src="{{ URL::asset('plugins/dttables/dataTables.bootstrap4.js') }}"></script>
    <script src="{{ URL::asset('plugins/dttables/dataTables.responsive.js') }}"></script>
    <script src="{{ URL::asset('plugins/dttables/responsive.bootstrap4.js') }}"></script>
	<!-- Summernote -->
	<script src="{{ URL::asset('plugins/summernote/summernote-bs4.min.js') }}"></script>
  <!-- Select2 -->
  <script src="{{ URL::asset('plugins/select2/js/select2.full.min.js') }}"></script>
	<!-- DateRangePicker -->
	<script src="{{ URL::asset('plugins/moment.js') }}"></script>
	<script src="{{ URL::asset('plugins/daterangepicker/daterangepicker.js') }}"></script>
  <!-- InputMask -->
  <script src="{{ URL::asset('plugins/inputmask/jquery.inputmask.min.js') }}"></script>
  <!-- ShowPwd -->
  <script src="{{ URL::asset('plugins/show-pwd/jquery.password-field.js') }}"></script>
  {{-- Dropify --}}
  <script src="{{ URL::asset('plugins/dropify/js/dropify.min.js') }}"></script>
	<!-- AdminLTE App -->
  <script src="{{ URL::asset('plugins/characterlimit.js') }}"></script>
	<script src="{{ URL::asset('dist/js/adminlte.min.js') }}"></script>
	<script src="{{ URL::asset('dist/js/script.js') }}"></script>
	<script>
		$('[data-toggle="tooltip"]').tooltip()
	</script>
    @yield('script')
	@include('sweetalert::alert')
</body>

</html>