@extends('admin.layout.app')
@section('content')
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
				<h1>Dashboard</h1>
			</div>
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
					<li class=" breadcrumb-item"><a href="#">Home</a></li>
					<li class=" breadcrumb-item active">Dashboard</li>
				</ol>
			</div>
    </div>
  </div>
</div>
<div class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-3">
        <div class="info-box">
          <span class="info-box-icon bg-info elevation-1">
            <i class="fas fa-photo-film-music"></i>
          </span>
          <div class="info-box-content">
            <span class="info-box-text">Media / Pengetahuan SPBE</span>
            <span class="info-box-number">{{ $media_count }} Media</span>
          </div>
        </div>
      </div>
      {{-- end media column --}}
      <div class="col-lg-3">
        <div class="info-box">
          <span class="info-box-icon bg-danger elevation-1">
            <i class="fas fa-newspaper"></i>
          </span>
          <div class="info-box-content">
            <span class="info-box-text">Berita / Postingan</span>
            <span class="info-box-number">{{ $post_count }} Berita</span>
          </div>
        </div>
      </div>
      {{-- end news column --}}
    </div>
    {{-- end row --}}
    <div class="row">
      <div class="col-lg-6">
        <div class="card mt-1">
          <div class="card-header border-0">
            <h3 class="card-title"><i class="fas fa-photo-film-music mr-2"></i>Media Terbaru</h3>
            <div class="card-tools">
              <a href="{{route('admin.media')}}" class="btn btn-tool btn-sm">
                <i class="fas fa-external-link"></i>
              </a>
            </div>
          </div>
          <div class="card-body table-responsive p-0">
            <table class="table table-striped table-valign-middle">
              <thead>
                <tr>
                  <th>Judul</th> 
                  <th style="width: 100px">Tanggal</th>
                </tr>
              </thead>
              <tbody>
                @if($recent_medias->count() > 0)
                  @foreach($recent_medias as $media)
                  <tr>
                    <td>{{ $media->title }}</td> 
                    <td>{{ $media->publication_date }}</td>
                  </tr>
                  @endforeach
                @else
                  <tr>
                    <td colspan="4" class="text-center">No Media Published.</td>
                  </tr>
                @endif
              </tbody>
            </table>
          </div>
        </div>
        <div class="card mt-3">
          <div class="card-header border-0">
            <h3 class="card-title"><i class="fas fa-newspaper mr-2"></i>Berita Terbaru</h3>
            <div class="card-tools">
              <a href="{{route('admin.berita')}}" class="btn btn-tool btn-sm">
                <i class="fas fa-external-link"></i>
              </a>
            </div>
          </div>
          <div class="card-body table-responsive p-0">
            <table class="table table-striped table-valign-middle">
              <thead>
                <tr>
                  <th>Judul</th> 
                  <th style="width: 100px">Tanggal</th>
                </tr>
              </thead>
              <tbody>
                @if($recent_posts->count() > 0)
                  @foreach($recent_posts as $post)
                  <tr>
                    <td>{{ $post->title }}</td> 
                    <td>{{ formatDate($post->post_date) }}</td>
                  </tr>
                  @endforeach
                @else
                  <tr>
                    <td colspan="4" class="text-center">No Media Published.</td>
                  </tr>
                @endif
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
@section('script')
  
@endsection