@extends('admin.layout.app')
@section('content')
<div class="content-header">
	<div class="container-fluid">
		<div class="row mb-2">
			<div class="col-sm-6">
				<h1>Data Berita</h1>
			</div>
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
					<li class=" breadcrumb-item"><a href="#">Home</a></li>
					<li class=" breadcrumb-item active">Berita</li>
				</ol>
			</div>
		</div>
	</div>
</div>
<div class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h3 class="card-title">Data Media</h3>
						<div class="card-tools">
							<div class="dropdown d-inline">
								<a href="#" class="btn btn-tool" data-toggle="dropdown">
									<i class="fas fa-cog"></i>
								</a>
								<div class="dropdown-menu dropdown-menu-right text-sm">
									@can('create berita')
									<a href="{{ route('admin.berita.create') }}" class="dropdown-item">
										<i class="fas fa-plus-square text-muted  fa-fw mr-1"></i>
										Tambah Berita
									</a>
									@endcan
									<a href="#" class="dropdown-item">
										<i class="fas fa-file-excel text-success mr-1 fa-fw"></i>
										Export Excel
									</a>
								</div>
							</div>
							<button type="button" onclick="table.ajax.reload()" class="btn btn-tool">
								<i class="fas fa-sync-alt"></i>
							</button>
							<button type="button" class="btn btn-tool" data-card-widget="maximize">
								<i class="fas fa-expand"></i>
							</button>
						</div>
					</div>
					<div class="card-body">
						<table class="table" style="width: 100%">
							<thead>
								<tr>
									<th></th>
									<th>Judul</th>
									<th>Gambar</th>
									<th>Isi</th>
									<th>Tgl. Publikasi</th>
									<th></th>
								</tr>
							</thead>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection
@section('script')
	<script>
    var user_role = '{{ auth()->user()->getRoleNames()[0] }}';
    var user_id = '{{ auth()->user()->id }}';

		var table = $('.table').DataTable({
      processing: true,
      serverSide: true, 
      ordering: false,
      ajax: {
        url: '{{route('admin.berita.listdata')}}',
        type: 'GET',
        header: {
          headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')}
        }
      },
      columns: [
        {data: null, width: '20px', class: 'text-right', orderable: false, render: function(data, type, row, meta){
            return meta.row + meta.settings._iDisplayStart + 1;
        }},
        {data: null, render: function(data){
            return `
            <div>
                <strong>${data.title}</strong><br>
                <span class="text-muted">${data.content}</span>
            </div>
            `;            
        }},
        {data: null, width: '180px', render: function(data, row){
          let imageURL = `{{url('uploads/foto-berita')}}/${data.image}`;
          return `<a href="${imageURL}"><img style="width: 150px;" src="${imageURL}"></a>`;
          // return 'a';
        }},
        {data: null, class:' text-wrap', render: function(data, row){
        //   return $('<div/>').html(data.content).text();
            return "";
        }},
        {data: 'post_date', class: 'text-center', width: '100px'},
        {data: 'action', width: '20px'}
      ]
		})

    function hapusBerita(post_id){
			var url = `{{ url('admin/berita/delete') }}/${post_id}`;
			confirm('Hapus Berita', 'Anda yakin ingin menghapus berita ini?', url, function(){
				table.ajax.reload();
			})
		}
	</script>
@endsection