@extends('admin.layout.app')
@section('content')
<div class="content-header">
	<div class="container-fluid">
		<div class="row mb-2">
			<div class="col-sm-6">
				<h1>Tambah Berita</h1>
			</div>
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
					<li class=" breadcrumb-item"><a href="#">Home</a></li>
					<li class=" breadcrumb-item"><a href="{{route('admin.berita')}}">Berita</a></li>
					<li class=" breadcrumb-item active">Tambah Berita</li>
				</ol>
			</div>
		</div>
	</div>
</div>
<div class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h3 class="card-title">Tambah Berita</h3>
					</div>
					<form action="{{route('admin.berita.store')}}" method="post" autocomplete="off" enctype="multipart/form-data">
						@csrf
						<div class="card-body">

							<div class="form-group row">
								<label for="" class="col-form-label col-lg-2">Judul</label>
								<div class="col-lg-10">
									<input type="text" class="form-control" name="title" required value="{{ old('title') }}">
								</div>
							</div>

              <div class="form-group row">
                <label for="" class="col-form-label col-lg-2">Gambar</label>
                <div class="col-lg-3">
                  <div style="margin-bottom: 10px">
                    <img src="{{URL::asset('img/noimage.jpg')}}" id="imageResult" style="width: 100%; min-height: 100px">
                  </div>
                  <input type="file" name="image" class="form-control" accept="image/*" onchange="readURL(this)">
                </div>
              </div>

              <div class="form-group row">
                <label for="" class="col-form-label col-lg-2">Isi Berita</label>
                <div class="col-lg-10">
                  <textarea name="content" class="form-control summernote">{{ old('content') }}</textarea>
                </div>
              </div> 

              <div class="form-group row">
								<label for="" class="col-form-label col-lg-2">Tanggal Berita</label>
								<div class="col-lg-2">
									<input type="text" class="form-control inputdate" data-inputmask-alias="datetime" data-inputmask-inputformat="yyyy-mm-dd" data-mask inputmode="numeric" name="post_date" required value="{{ old('post_date') ? old('post_date') : date('Y-m-d') }}">
								</div>
							</div>

              <div class="form-group row">
								<label for="" class="col-form-label col-lg-2">Waktu Berita</label>
								<div class="col-lg-2">
									<input type="text" class="form-control" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:MM:ss" data-mask inputmode="numeric" name="post_time" required value="{{ old('post_time') ? old('post_time') : date('H:i:s') }}">
								</div>
							</div>
						</div>
            <div class="card-footer d-flex">
              <a href="{{ route('admin.berita') }}" class="btn btn-default">Batal</a>
              <button type="submit" class="btn btn-primary ml-auto">Simpan</button>
            </div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection
@section('script')
<script>
  $('.summernote').summernote();

  function readURL(input){
    if(input.files && input.files[0]){
      var reader = new FileReader();

      reader.onload = function(e){
        $('#imageResult').attr('src', e.target.result);
      };
      reader.readAsDataURL(input.files[0]);
    }
  }

  $('[data-mask]').inputmask();

  $('.select2').select2();
</script>
@endsection