(function($) {
    var methods = {
        init: function() {
            $(this).find('span').css('display', 'none');
            var icon = $(this).find('i');

            if (icon.length == 0)
                $(this).append('<i class="fas fa-spin fa-spinner"></i>');
            else
                icon.css('display', 'block');
            $(this).attr('disabled', 'disabled');
        },
        reset: function() {
            $('#btn-indicator').remove();
            $(this).find('span').css('display', 'block');
            $(this).find('i').css('display', 'none');
            $(this).removeAttr('disabled');
        }
    };

    $.fn.indicator = function(methodOrOptions) {
        if (methods[methodOrOptions]) {
            return methods[methodOrOptions].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof methodOrOptions === 'object' || !methodOrOptions) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Method ' + methodOrOptions + 'does no exist on jQuery.indicator');
        }
    }
})(jQuery);

const Toast = Swal.mixin({
    toast: true,
    position: "top-end",
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.onmouseenter = Swal.stopTimer;
        toast.onmouseleave = Swal.resumeTimer;
    }
});

function showDetail(data) {
    data.sex = data.sex == 'male' ? 'Pria' : 'Wanita';
    var modal = `
    <div class="modal fade">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Detail For ${data.name}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table table-borderless table-sm">
                        <tr><td>Name</td><td>${data.name}</td></tr>
                        <tr><td>Jenis Kelamin</td><td>${data.sex}</td></tr>
                        <tr><td>Unit Kerja</td><td>${data.unit_name}</td></tr>
                        <tr><td>Pangkat / Golongan</td><td>${data.grade_class}</td></tr>  
                        <tr><td>Position</td><td>${data.position}</td></tr>  
                        <tr><td>NIP</td><td>${data.nip}</td></tr>  
                        <tr><td>Email</td><td>${data.email}</td></tr>  
                        <tr><td>Telepon</td><td>${data.phone}</td></tr>  
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Tutup</button>
                </div>
            </div>
        </div>
    </div>
    `;
    modal = $(modal).appendTo('body');
    modal.modal('show');
}


function confirm(_title, _text, _url, callback) {
    Swal.fire({
        icon: 'question',
        title: _title,
        text: _text,
        showCancelButton: true,
        reverseButtons: true,
        showLoaderOnConfirm: true,
        preConfirm: async() => {
            try {
                const response = await fetch(_url, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                if (!response.ok) {
                    return Swal.showValidationMessage(`${JSON.stringify(await response.json())}`)
                }

                return response.json();

            } catch (error) {
                Swal.showValidationMessage(`Request failed: ${error}`);
            }
        },
        allowOutsideClick: () => !Swal.isLoading()
    }).then(result => {
        if (result.isConfirmed) {
            if (result.value.status || result.value.success) {
                Swal.fire({ 'icon': 'success', 'title': result.value.message });
                callback();
                // table.ajax.reload();
            } else {
                Swal.fire({ 'icon': 'error', 'title': result.value.message });
            }
        }
    })
}

function ucwords(str_word) {
    str = str_word.toLowerCase().replace(/\b[a-z]/g, function(str_word) {
        return str_word.toUpperCase();
    });
    return str;
}