<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class UserRolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user_admin = User::create([
            'opd_id' => '1',
            'name' => 'Administrator',
            'sex' => 'male',
            'nip' => '-',
            'grade_class' => 'Pembina Muda I/A',
            'position' => 'Ahli Pertama Pranata Komputer',
            'phone' => '0239499923999',
            'email' => 'admin@gmail.com',
            'email_verified_at' => null,
            'password' => Hash::make('12345678')
        ]);

        $role_admin = Role::create(['name' => 'admin']);
        $role_operator = Role::create(['name' => 'operator']);

        $permissions = [
            'list user',
            'create user',
            'update user',
            'delete user',
            'list opd',
            'create opd',
            'update opd',
            'delete opd',
            'list category',
            'create category',
            'update category',
            'delete category',
            'list media',
            'create media',
            'update media',
            'delete media',
            'list berita',
            'create berita',
            'update berita',
            'delete berita',
        ];

        $operator_permission = [
            'update user',
            'list media',
            'create media',
            'update media',
            'delete media',
            'list berita',
            'create berita',
            'update berita',
            'delete berita'
        ];

        foreach($permissions as $permission){
            Permission::create(['name' => $permission]);
            $role_admin->givePermissionTo($permission);
        }

        foreach($operator_permission as $permission){
            $role_operator->givePermissionTo($permission);
        }

        $user_admin->assignRole($role_admin);
    }
}
