<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('media', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->integer('opd_id');
            $table->integer('category_id');
            $table->string('title');
            $table->string('writer');
            $table->text('description');
            $table->string('tags');
            $table->string('contributor')->nullable(true);
            $table->string('visibility');
            $table->string('link');
            $table->date('publication_date');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('media');
    }
};
