<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Post;
use App\Models\Media;
use App\Models\Opd;
use App\Models\Video;
use App\Models\User;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class HomeController extends Controller
{
    public function index() 
    {
        $list_opd = Opd::all();
        $list_kategori = Category::all();
        $recentsPosts = Post::orderBy('created_at', 'desc')->take(8)->get();
        // $total_media = count(Media::findAll());
        return view('home', [
            'opd' => $list_opd,
            'kategori' => $list_kategori,
            'recentsPosts' => $recentsPosts,
            
            // 'total_media' => $media
        ]);
    }

    public function posts()
    {
        $recentsVideos = Video::orderBy('created_at', 'desc')->take(8)->get();
      $recentsPosts = Post::orderBy('created_at', 'desc')->get();
      return view('posts', ['recentsPosts' => $recentsPosts, 'recentsVideos' => $recentsVideos]);
    }

    public function postView($slug){
      $post = Post::where('slug', $slug)->first();
      $recentsVideos = Video::orderBy('created_at', 'desc')->take(8)->get();
      $recentsPosts = Post::orderBy('created_at', 'desc')->take(5)->get();
      
        $post_img = null;
        if(!is_null($post->image))
            $post_img = url('uploads/foto-berita/'.$post->image);
      
        $meta = [
            ['name', 'description', strtolower($post->title)],
            ['name', 'keywords', 'Berita Simantu NTT'],
            ['name', 'author', User::where('id', $post->user_id)->first()->name],
            ['name', 'thumbnailUrl', $post_img],
            ['property', 'og:site_name', 'SIMANTU | Sistem Informasi Manajemen Pengetahuan Provinsi NTT'],
            ['property', 'og:title', $post->title],
            ['property', 'og:image', $post_img],
            ['property', 'og:image:type', 'image/jpeg'],
            ['property', 'og:image:width', 650],
            ['property', 'og:image:height', 300],
        ];
        
        
      return view('post-view', [
          'page_title' => $post->title,
          'meta' => $meta,
          'post' => $post, 
          'recentPosts' => $recentsPosts,
          'recentVideos' => $recentsVideos
        ]);
    }
    
    public function videos()
    {
        $videos = Video::orderBy('created_at', 'desc')->get();
        return view('videos', ['videos' => $videos]);
    }

    public function daftarMedia(Request $request)
    {
      $model = Media::query();

      return DataTables::eloquent($model)
        ->order(function($query){
            $query->orderBy('created_at', 'desc');
        })
        ->filter(function ($query) use ($request) {
          if(!empty($request->opd))
            $query->where('opd_id', $request->opd);
          if(!empty($request->category))
            $query->where('category_id', $request->category);
          if(!empty($request->tag))
            $query->where('tags', 'like', '%'.$request->tag.'%');
          
          if($request->pub == '1')
            $query->where('visibility', '1');
          else
            $query->where('visibility', '0');
        })
        ->addColumn('opd_name', function(Media $media) {
          $opd = Opd::find($media->opd_id);
          return $opd->name;
        })
        ->addColumn('category_name', function(Media $media) {
          $category = Category::find($media->category_id);
          return $category->name;
        })
        ->editColumn('updated_at', function(Media $media) {
          return \formatDate($media->updated_at, '%d-%m-%Y %H:%M');
        })
        ->editColumn('description', function(Media $media) {
          return \substr($media->description, 0, 100). '...';
        })
        ->toJson();
    }
}
