<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Opd;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password;
use Yajra\DataTables\Facades\DataTables;

class UserController extends Controller
{
    public function index(Request $request)
    {
        if(Gate::allows('list user'))
            return view('admin.users.index', ['page_title' => 'Data User']);
        else
            abort('403', 'unauthorized');
    }

    public function profile()
    {
      $user = Auth::user();
      $opd = Opd::all();
      return view('admin.users.profile', ['user' => $user, 'opd' => $opd]);
    }

    public function edit($user_id)
    {
        $user = User::find($user_id);
        $opd = Opd::all();
        return view('admin.users.edit', ['user' => $user, 'opd' => $opd]);
    }

    public function update(Request $request)
    {
        $data = $request->all();
        unset($data['_token']);
        unset($data['id']);
        unset($data['password']);

        if(!empty($request->password))
            $data['password'] = Hash::make($request->password);

        $user = User::find($request->id);
        $user->update($data);

        return redirect()->route('admin.users')->withToastSuccess("User berhasil diupdate");
    }

    public function listData(Request $request)
    {
        if(!Gate::allows('list user'))
            abort('403', 'unauthorized');

        $model = User::query();

        return DataTables::eloquent($model)
            ->addColumn('unit_name', function(User $user){
                $unit = Opd::find($user->opd_id);

                if(!$unit)
                    return "null";
                else
                    return $unit->name;
            })
            ->addColumn('action', function(User $user){
                $html = "<a href='' class='btn btn-warning btn-sm'><i class='bi bi-lock-fill'></i></a>";

                return $html;
            })
            ->addColumn('level', function(User $user){
                $level = $user->getRoleNames()[0] ?? '';
                return $level;
            })
            ->toJson();
    }

    public function confirm($user_id)
    {
        $user = User::find($user_id);
        $user->update(['status' => 'active']);

        return response(['status' => true, 'message' => 'User berhasil diaktifkan']);
    }

    public function lock($user_id)
    {
        $user = User::find($user_id);
        $user->update(['status' => 'locked']);

        return response(['status' => true, 'message' => 'User berhasil dikunci']);
    }

    public function unlock($user_id)
    {
        $user = User::find($user_id);
        $user->update(['status' => 'active']);

        return response(['status' => true, 'message' => 'User berhasil diaktifkan']);
    }

    public function updateProfile(Request $request)
    {
      $user = Auth::user();
      $user->name = $request->name;
      $user->sex = $request->sex;
      $user->nip = $request->nip;
      $user->grade_class = $request->grade_class;
      $user->position = $request->position;
      $user->phone = $request->phone;
      $user->email = $request->email; 

      $user->save();

      return redirect()->route('admin.users.profile')->with('success', 'Profile berhasil diubah');
    }

    public function changePassword(Request $request)
    {
      $request->validate([
        'old_pass' => ['required', 'current_password'],
        'new_pass' => ['required',],
        'confirm_pass' => ['required', 'same:new_pass'],
      ]);

      $user = Auth::user();

      $user->password = Hash::make($request->new_pass);
      $user->save();
      return redirect()->route('admin.users.profile')->with('success', 'Password berhasil diubah');
    }
}
