<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Post;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\Facades\DataTables;

class PostController extends Controller
{
	public function index()
	{
		return view('admin.berita.index', ['page_title' => 'Simantu | Berita']);
	}

	public function create()
	{
		return view('admin.berita.create', ['page_title' => 'Simantu | Buat Berita']);
	}

  public function edit($id_post)
  {
    $post = Post::find($id_post);
    return view('admin.berita.edit', ['page_title' => 'Edit Berita', 'post' => $post]);
  }

	public function store(Request $request)
	{
    if(!Gate::allows('create berita'))
      abort(403, 'unauthorized');

		$user = Auth::user();
		$data['user_id'] = $user->id;
		$data['opd_id'] = $user->opd_id;
		$data['title'] = $request->title;
		$data['content'] =  base64_encode(htmlspecialchars($request->content));
		$data['post_date'] = $request->post_date;
		$data['post_time'] = $request->post_time;

    $request->validate([
      'image' => 'required|mimes:jpg,jpeg|max:1024'
    ]);

    $filename = time().'.'.$request->image->extension();
    
    $request->image->move(public_path('uploads/foto-berita'), $filename);

    $data['image'] = $filename;
    $slug = strtolower($request->title);
    $slug = str_replace(' ', '-', $slug);
    $slug = str_replace('/', '-', $slug);
    $slug = str_replace(':', '-', $slug);
    $slug = str_replace('(', '-', $slug);
    $slug = str_replace(')', '-', $slug);
    $slug = str_replace('=', '-', $slug);
    $slug = str_replace('_', '-', $slug);
    $data['slug'] = $slug;

		Post::create($data);

    return redirect()->route('admin.berita')->withToastSuccess('Berita berhasil dibuat.');
	}

  public function update(Request $request)
  {
    if(!Gate::allows('update berita'))
      abort(403, 'unauthorized');

    $user = Auth::user();
    $post = Post::find($request->id);

    if (!$user->hasRole('admin') && $user->id != $post->user_id)
      abort(403, 'not allowed action');


      $data['user_id'] = $post->user_id;
      $data['title'] = $request->title;
      $data['content'] =  base64_encode(htmlspecialchars($request->content));
      $data['post_date'] = $request->post_date;
      $data['post_time'] = $request->post_time;

      if(!is_null($request->image)) {
        $request->validate([
          'image' => 'required|mimes:jpg,jpeg|max:1024'
        ]);
    
        $filename = time().'.'.$request->image->extension();
        
        $request->image->move(public_path('uploads/foto-berita'), $filename);
    
        $data['image'] = $filename;
      }
      
        $slug = strtolower($request->title);
        $slug = str_replace(' ', '-', $slug);
        $slug = str_replace('/', '-', $slug);
        $slug = str_replace(':', '-', $slug);
        $slug = str_replace('(', '-', $slug);
        $slug = str_replace(')', '-', $slug);
        $slug = str_replace('=', '-', $slug);
        $slug = str_replace('_', '-', $slug);
      $data['slug'] = $slug;


    $post->update($data);

    return redirect()->route('admin.berita')->withToastSuccess('Berita berhasil diupdate.');
    
  }

  public function listdata(Request $request){
    $model = Post::query();

    // $model = Post::query();

    return DataTables::eloquent($model)
      ->filter(function($query){
        $user = Auth::user();
        if(!$user->hasRole('admin')){
          $query->where('opd_id', $user->opd_id);
        }
      })
      ->editColumn('post_date', function(Post $post){
        setlocale(LC_ALL,  'id-ID');
        return strftime("%d-%m-%Y", strtotime($post->post_date));
      })
      ->editColumn('content', function(Post $post){
        $content = base64_decode($post->content);
        $content = htmlspecialchars_decode($content);
        // $content = htmlentities($content);
        return substr(strip_tags($content), 0, 200) . '....';
      })
      ->addColumn('action', function(Post $post){
        $user = Auth::user();
        $role = $user->getRoleNames()[0];

        $html = "<div class=\"dropdown\">"
          ."<a href=\"#\" data-toggle=\"dropdown\" class=\"text-secondary text-sm\">"
          ."<i class=\"fas fa-cog\"></i><a/>"
          ."<div class=\"dropdown-menu dropdown-menu-right text-sm\">";
        if($user->hasPermissionTo('update berita')){
          $html .= "<a href=\"".url('admin/berita/edit/'.$post->id)."\" class=\"dropdown-item\"><i class=\"fas fa-edit mr-2\"></i>Edit</a>";
        }
        if($user->hasPermissionTo('delete berita')){
          $html .= "<a href=\"#\" class=\"dropdown-item\" onclick=\"event.preventDefault(); hapusBerita($post->id)\"><i class=\"fas fa-trash-alt mr-2\"></i>Hapus</a>";
        }
        $html .= "</div></div>";

        if($role == "admin" || $user->id == $post->user_id)
          return $html;

        else
          return '';
      })
      ->rawColumns(['action'])
      ->toJson();
  }

  public function destroy($post_id)
  {
    if(!Gate::allows('delete berita'))
      abort(403, 'unauthorized');

    $post = Post::find($post_id);
    $user = Auth::user();
    
    if(!$user->hasRole('admin')){
        if($post->user_id != $user->id)
          abort(403, 'unauthorized');
    }

    $file = public_path('uploads/foto-berita/'.$post->image);

    if(is_file($file))
      unlink($file);

    Post::destroy($post_id);

    return response(['status' => true, 'message' => 'Item berhasil dihapus!']);
  }
}
