<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Opd;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\Facades\DataTables;

class OpdController extends Controller
{
    public function index() {
        if(Gate::allows('list opd'))
            return view('admin.opd.index', ['page_title' => 'Data Perangkat Daerah']);
        else
            abort('403', 'unauthorized');
    }

    public function listData(Request $request)
    {
        if(!Gate::allows('list opd'))
            abort('403', 'unauthorized list opd request');

        $model = Opd::query();

        return DataTables::eloquent($model)
            ->toJson();
    }

    public function store(Request $request)
    {
        if(!Gate::allows('create opd'))
            abort('403', 'unauthorized');

        $data = array();
        $data['name'] = $request->name;
        $data['address'] = $request->address;
        $data['description'] = $request->description;

        

        Opd::create($data);

        return response([
            'success' => true,
            'message' => 'Data berhasil ditambahkan!'
        ]);
        
    }

    public function update(Request $request, $opd_id){
        if(!Gate::allows('update opd'))
            abort('403', 'unauthorized');

        $data = array();
        $data['name'] = $request->name;
        $data['address'] = $request->address;
        $data['description'] = $request->description;

        $opd = Opd::findOrFail($opd_id);
        $opd->update($data);

        return response([
            'success' => true,
            'message' => 'Data berhasil diupdate!'
        ]);
    }

    public function destroy($opd_id){
        if(!Gate::allows('delete opd'))
            abort('403', 'unauthorized');

        $find_index = User::where('opd_id', $opd_id)->first();

        if($find_index)
            return response(['status' => false, 'message' => 'Tidak dapat menghapus item ini karena masih terhubung dengan item lain.']);
        else {
            Opd::destroy($opd_id);

            return response(['status' => true, 'message' => 'Item berhasil dihapus!']);
        }
    }

    public function getItem($opd_id){
        $opd = Opd::find($opd_id);

        return response($opd);
    }
}
