<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Media;
use App\Models\Opd;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use RealRashid\SweetAlert\Facades\Alert;
use Yajra\DataTables\Facades\DataTables;

class MediaController extends Controller
{
    public function index(){
        return view('admin.media.index', [
          'page_title' => 'Pengetahuan Umum'
        ]);
    }
    
    public function khusus(){
        return view('admin.media.khusus', [
            'page_title' => 'Pengetahuan Khusus'
        ]);
    }

    public function create()
    {
        if(!Gate::allows('create media'))
            abort(403, 'unauthorized');
        $user = Auth::user();
        $opd = Opd::find($user->opd_id);
        $categories = Category::all();

        return view('admin.media.create', ['opd' => $opd, 'categories' => $categories,'page_title' => 'Tambah Media']);
    }

    public function edit($media_id){
        if(!Gate::allows('update media'))
            abort(403, 'unauthorized');

        $categories = Category::all();
        $media = Media::find($media_id);
        $user = User::find($media->user_id);
        $opd = Opd::find($user->opd_id);

        return view('admin.media.edit', ['opd' => $opd, 'categories' => $categories, 'media' => $media]);
    }

    public function listData(Request $request)
    {
        $model = Media::query();

        return DataTables::eloquent($model)
            ->filter(function($query){
                $query->where('visibility', '1');
            })
            ->order(function($query){
                $query->orderBy('created_at', 'desc');
            })
            ->addColumn('opd_name', function(Media $media){
              $opd = Opd::find($media->opd_id);
              return $opd->name;
            })
            ->editColumn('publication_date', function(Media $media){
                setlocale(LC_ALL,  'id-ID');
                return strftime("%d-%m-%Y", strtotime($media->publication_date));
            })
            ->addColumn('category_name', function(Media $media){
              $category = Category::find($media->category_id);
              return $category->name;
            })
            ->editColumn('visibility', function(Media $media){
              return $media->visibility == '0' ? 'Khusus' : 'Umum';
            })
            ->toJson();
    }
    
    public function listDataKhusus(Request $request)
    {
        $model = Media::query();

        return DataTables::eloquent($model)
            ->filter(function($query){
                $query->where('visibility', '0');
            })
            ->order(function($query){
                $query->orderBy('created_at', 'desc');
            })
            ->addColumn('opd_name', function(Media $media){
              $opd = Opd::find($media->opd_id);
              return $opd->name;
            })
            ->editColumn('publication_date', function(Media $media){
                setlocale(LC_ALL,  'id-ID');
                return strftime("%d-%m-%Y", strtotime($media->publication_date));
            })
            ->addColumn('category_name', function(Media $media){
              $category = Category::find($media->category_id);
              return $category->name;
            })
            ->editColumn('visibility', function(Media $media){
              return $media->visibility == '0' ? 'Khusus' : 'Umum';
            })
            ->toJson();
    }

    public function store(Request $request)
    {
        $user = Auth::user();
        // print_r($request->media);

        // exit();

        $request->validate([
          'media' => 'mimes:pdf,docx,doc|max:5120',
        ]);

        $data                     = array();
        $data['user_id']          = $user->id;
        $data['opd_id']           = $user->opd_id;
        $data['category_id']      = $request->category_id;
        $data['title']            = $request->title;
        $data['writer']           = $request->writer;
        $data['description']      = $request->description;
        $data['tags']             = $request->tags;
        $data['contributor']      = $request->contributor;
        $data['visibility']       = $request->visibility;
        $data['publication_date'] = $request->publication_date;
        $data['link']             = $request->link;

        if(!is_null($request->media)):
            $filename = time().'.'.$request->media->extension();
            
            $request->media->move(public_path('uploads/media'), $filename);
        
            $data['media'] = $filename;
        endif;


        Media::create($data);

        return redirect('admin/media')->withSuccess('Media Created Successfully');

    }

    public function update(Request $request){
        $user = Auth::user();

        $data                     = array();
        $data['user_id']          = $user->id;
        $data['category_id']      = $request->category_id;
        $data['title']            = $request->title;
        $data['writer']           = $request->writer;
        $data['description']      = $request->description;
        $data['tags']             = $request->tags;
        $data['contributor']      = $request->contributor;
        $data['visibility']       = $request->visibility; 
        $data['publication_date'] = $request->publication_date;
        $data['link']             = $request->link;

        $media = Media::find($request->id);

        if(!is_null($request->media)){
          $request->validate([
            'media' => 'mimes:pdf,docx,doc|max:5120',
          ]);
          $old_media = public_path("uploads/media/".$media->media);
          if(is_file($old_media))
            unlink($old_media);

          $filename = time().'.'.$request->media->extension();
          $data['media'] = $filename;
      
          $request->media->move(public_path('uploads/media'), $filename);
        }

        $media->update($data);

        return redirect('admin/media')->withToastSuccess('Media Updated Successfully');
    }

    public function destroy($media_id)
    {
        if(!Gate::allows('delete media'))
            abort('403', 'unauthorized');

        Media::destroy($media_id);

        return response(['status' => true, 'message' => 'Item berhasil dihapus!']);
    }
}
