<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Media;
use App\Models\Post;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $role = $user->getRoleNames()[0];

        $media_count = DB::table('media');
        if ($role === 'admin') {
            $media_count = $media_count->count();
        } else {
            $media_count = $media_count->where('opd_id', $user->opd_id)->count();
        }

        $recent_medias = DB::table('media');
        if ($role === 'admin') {
            $recent_medias = $recent_medias->orderBy('created_at', 'desc')->take(5)->get();
        } else {
            $recent_medias = $recent_medias->where('opd_id', $user->opd_id)->orderBy('created_at', 'desc')->take(5)->get();
        }

        $new_media = Media::orderBy('created_at', 'desc')->where('opd_id', $user->opd_id)->take(5)->get();

        $post_count = DB::table('posts');
        if ($role === 'admin') {
            $post_count = $post_count->count();
        } else {
            $post_count = $post_count->where('opd_id', $user->opd_id)->count();
        }
        
        $recent_posts = DB::table('posts');
        if ($role === 'admin') {
          $recent_posts = $recent_posts->orderBy('posts.created_at', 'desc')
            ->take(5)
            ->get();
        }else{
          $recent_posts = $recent_posts->where('posts.opd_id', $user->opd_id)
            ->orderBy('posts.created_at', 'desc')
            ->take(5)
            ->get();
        }

        return view('admin.dashboard', [
          'media_count' => $media_count,
          'recent_medias' => $recent_medias,
          'post_count' => $post_count,
          'recent_posts' => $recent_posts,
          'user' => $user,
        ]);
    }
}
