<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Media;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\Facades\DataTables;

class CategoryController extends Controller
{
    public function index()
    {
        if(Gate::allows('list category'))
            return view('admin.kategori.index', ['page_title' => 'Data Kategori']);
        else
            abort('403', 'unauthorized');
    }

    public function store(Request $request)
    {
        $data = [
            'name' => $request->name,
            'description' => $request->description
        ];

        Category::create($data);

        return response([
            'success' => true,
            'message' => 'Data berhasil ditambahkan!'
        ]);
    }

    public function update(Request $request, $category_id)
    {
        if(!Gate::allows('update category'))
            abort('403', 'unauthorized');

        $data = array();
        $data['name'] = $request->name;
        $data['description'] = $request->description;

        $category = Category::findOrFail($category_id);
        $category->update($data);

        return response([
            'success' => true,
            'message' => 'Data berhasil diupdate!'
        ]);
    }

    public function destroy($category_id)
    {
        if(!Gate::allows('delete category'))
            abort('403', 'unauthorized');

        $find_index = Media::where('category_id', $category_id)->first();

        if($find_index)
            return response(['status' => false, 'message' => 'Tidak dapat menghapus item ini karena masih terhubung dengan item lain.']);
        else {
            Category::destroy($category_id);

            return response(['status' => true, 'message' => 'Item berhasil dihapus!']);
        }
    }

    public function listData(Request $request)
    {
        if(!Gate::allows('list category'))
            abort('403', 'unauthorized list category request');

        $model = Category::query();

        return DataTables::eloquent($model)
            ->toJson();
    }

    public function getItem($category_id)
    {
        $category = Category::findOrFail($category_id);

        return response($category);
    }
}
