<?php

use Illuminate\Support\Facades\Auth;

if(!function_exists('decodeContent')){
  function decodeContent($content){
    $content = base64_decode($content);
    $content = htmlspecialchars_decode($content);

    return $content;
  }
}

if(!function_exists('encodeContent')){
  function encodeContent($content){
    $content = htmlspecialchars($content);
    $content = base64_encode($content);

    return $content;
  }
}

if(!function_exists('getUser')){
  function getUser(){
    $user = Auth::user();

    return $user;
  }
}

if(!function_exists('formatDate')){
  function formatDate($date, $format = '%d-%m-%Y'){
    setlocale(LC_ALL, 'id_ID');
    return strftime($format, strtotime($date));
  }
}