<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="author" content="Kodinger">
	<meta name="viewport" content="width=device-width,initial-scale=1">
	<title>My Login Page</title>
	<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
	<link rel="stylesheet" type="text/css" href="css/my-login.css">
	 <!-- SweetAlert2 -->
  <link rel="stylesheet" href="plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css">
</head>

<body class="my-login-page">
	<section class="h-100">
		<div class="container h-100">
			<div class="row justify-content-md-center h-100">
				<div class="card-wrapper">
					<div class="brand">
						<img src="img/logo.jpg" alt="logo">
					</div>
					<div class="card fat">
						<div class="card-body">
							<h4 class="card-title">Login</h4>
							<form class="my-login-validation">
								<div id="hasil">
								    	
							    	</div>
								<div class="form-group">
									<label for="email">Username</label>
									<input id="email" type="text" class="form-control" name="username" value="" required autofocus>
									<div class="invalid-feedback">
										Username tidak ditemukan
									</div>
								</div>

								<div class="form-group">
									<label for="password">Password
										<!-- <a href="forgot.html" class="float-right">
											Forgot Password?
										</a> -->
									</label>
									<input id="password" type="password" class="form-control" name="password" required data-eye>
								    <div class="invalid-feedback">
								    	Password is required
							    	</div>
								</div>

								<div class="form-group">
									<div class="custom-checkbox custom-control">
										<input type="checkbox" name="remember" id="remember" class="custom-control-input">
										<label for="remember" class="custom-control-label">Remember Me</label>
									</div>
								</div>

								<div class="form-group m-0">
									<button type="button" id="klik" class="btn btn-primary btn-block">
										Login
									</button>
								</div>
								<!-- <div class="mt-4 text-center">
									Don't have an account? <a href="register.html">Create One</a>
								</div> -->
							</form>
						</div>
					</div>
					<div class="footer">
						Copyright &copy; <?php echo date("Y"); ?> &mdash; BPPD PROVINSI NTT 
					</div>
				</div>
			</div>
		</div>
	</section>

	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
	<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
	<script src="js/my-login.js"></script>
	<!-- SweetAlert2 -->
	<script src="plugins/sweetalert2/sweetalert2.min.js"></script>
	<script type="text/javascript">
	 $(document).ready(function(){
			$("#klik").click(function(e) {
						$.ajax({
				        url: "cek_login.php",
				        type: "post",
				        data: $("form[class=my-login-validation]").serialize(),
				        success: function (hasil) {
				       		if(hasil==1){
				       			Swal.fire({
					              position: 'top-end',
					              icon: 'success',
					              title: 'Login Berhasil',
					              showConfirmButton: false,
					              timer: 2000
					            }).then((result) => {  location.href = '../admin/' })
				       		}else{
				       			Swal.fire({
					              position: 'top-end',
					              icon: 'error',
					              title: 'Username atau Password Salah',
					              // text: 'Username atau Password Salah',
					              showConfirmButton: false,
					              timer: 1500
					            })
				       		}
						}
					})
				})
	})
	</script>
</body>
</html>
